% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hourly_windspeed.R
\name{hourly_windspeed}
\alias{hourly_windspeed}
\title{Estimation of the hourly wind speed from daily mean data}
\usage{
hourly_windspeed(climdata)
}
\arguments{
\item{climdata}{a dataframe with daily wind speed data.
Required columns are Year, Month, Day and u2med. u2max
is an optional data column.}
}
\value{
dataframe with the columns Date, Year, Month, Day, DOY,
Hour and u2 (hourly wind speed, m s-1).
}
\description{
This function estimates the hourly wind speed from a
dataset with mean daily wind speeds. Hourly wind speeds
from daily values are computed using the formulas proposed
by Guo et al (2016), using mean daily values (u2med, required)
and maximum ones (u2max, optional). If only mean wind values
are available, the function uses a modified version of the 
Guo formula, so that the maximum values are obtained in 
daytime hours.
}
\examples{

# Generate hourly wind speed for the example dataset
library(magrittr)
library(dplyr)
library(lubridate)
Tudela_Hu2 <- hourly_windspeed(Tudela_DW)

}
\references{
Guo Z, Chang C, Wang R, 2016. A novel method to downscale daily wind
statistics to hourly wind data for wind erosion modelling. In: Bian F.,
Xie Y. (eds) Geo-Informatics in Resource Management and Sustainable
Ecosystem. GRMSE 2015. Communications in Computer and Information Science,
vol 569. Springer, Berlin, Heidelberg
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
