% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ET_Penman_Monteith.R
\name{ET_penman_monteith}
\alias{ET_penman_monteith}
\title{Calculation of daily reference evapotranspiration by Penman-Monteith method}
\usage{
ET_penman_monteith(climdata, lat, elev)
}
\arguments{
\item{climdata}{a dataframe with daily weather data.
Required columns are Year, Month, Day, Tmax and Tmin. Optional columns are
RHmax, RHmin, Rad and u2med.}

\item{lat}{the latitude of the site, in decimal degrees.}

\item{elev}{the elevation of the site, in meters above sea level.}
}
\value{
dataframe with Year, Month, Day, DOY, ETos and ETrs values.
}
\description{
This function calculates the reference evapotranspiration (ETref) for short
(ETos) and tall (ETrs) canopies using daily weather data. The method is based
on the FAO56 guidelines (Allen et al, 1998) and on the standardized Penman Monteith 
equation from the Environmental Water Resources Institute of the American 
Society of Civil Engineers (Allen et al, 2005).
}
\details{
Minimum data requirements to calculate ET are daily temperatures (maximum 
and minimum temperatures, Tmax and Tmin), whereas relative humidity (RHmax and 
RHmin), solar radiation (Rad, MJ m-2 day-1) and mean wind speed at 2m height
(u2med,m s-1) are optional. If missing, the function integrates FAO56 estimations 
for solar radiation and vapor pressure (air humidity) from daily 
temperatures. If there is no information available on wind speed, the function 
assumes a constant value of 2 m s-1.
}
\examples{

# Calculate ET by Penman-Monteith method in the Tudela_DW example dataset
library(magrittr)
library(dplyr)
elevation <- 314
latitude <- 42.13132
ET_PM <- ET_penman_monteith(Tudela_DW, latitude, elevation)

}
\references{
Allen RG, Pereira LS, Raes D, Smith M. 1998. Crop evapotranspiration. Guidelines
for computing crop water requirements. FAO Irrigation and drainage paper 56. Food 
and Agriculture Organization of the United Nations

Allen RG, Walter IA, Elliott RL, Howell TA, Itenfisu D, Jensen ME, Snyder RL 2005. 
The ASCE standardized reference evapotranspiration equation. Reston, VA:American 
Society of Civil Engineers. 59 p.
}
\author{
Carlos Miranda, \email{carlos.miranda@unavarra.es}
}
