% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hilma.R
\name{hilma}
\alias{hilma}
\title{Estimation and Inference for High Dimensional Mediation Analysis}
\usage{
hilma(
  Y,
  G,
  S,
  mediation_setting = "incomplete",
  tuning_method = "uniform",
  lam_list = NA,
  min.ratio = 0.1,
  n.lambda = 5,
  center = TRUE
)
}
\arguments{
\item{Y}{The n-dimensional outcome vector.}

\item{G}{The n by p mediator matrix. p can be larger than n.}

\item{S}{The n by q exposure matrix. q can be 1, and q < n is required.}

\item{mediation_setting}{Either `incomplete' or `complete'}

\item{tuning_method}{`uniform' or `aic', the default is `uniform'}

\item{lam_list}{tuning parameter for uniform tuning or list of tuning parameter for aic tuning}

\item{min.ratio}{the ratio of the minimum lambda to the maximum}

\item{n.lambda}{number of tuning parameters to choose from}

\item{center}{center the data or not, the default is TRUE}
}
\value{
A list with components:
\item{beta_hat}{estimated indirect effect}
\item{alpha1_hat}{estimated direct effect}
\item{pvalue_beta_hat}{the p value for testing the significance of the indirect effect}
\item{lambda_used}{lambda used during optimization}
}
\description{
This function implements the estimation and inference for the indirect effect in high dimensional linear mediation analysis models. It provides estimates and p-values under both incomplete mediation, where a direct effect may exist, as well as complete mediation, where the direct effect is known to be absent.
}
\examples{
n = 30
p = 50
q = 2
G = MASS::mvrnorm(n, rep(0,p), diag(p))
S = as.matrix(MASS::mvrnorm(n, rep(0,q), diag(q)))
Y = as.matrix(rnorm(n))
out = hilma(Y,G,S, mediation_setting = 'complete', tuning_method = 'uniform', lam_list = 0.2)
out
}
\author{
Ruixuan Zhou
}
