% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fredr_series.R
\name{fredr_series}
\alias{fredr_series}
\title{Return basic information for a FRED series.}
\usage{
fredr_series(series_id, ..., realtime_start = NULL, realtime_end = NULL)
}
\arguments{
\item{series_id}{A string ID for the FRED series.}

\item{...}{These dots only exist for future extensions and should be empty.}

\item{realtime_start}{A \code{Date} indicating the start of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}

\item{realtime_end}{A \code{Date} indicating the end of the real-time period.
Defaults to today's date. For more information, see
\href{https://fred.stlouisfed.org/docs/api/fred/realtime_period.html}{Real-Time Periods}.}
}
\value{
A \code{tibble} object (1 row) with information for the series specified by
\code{series_id}.
}
\description{
Given a series ID, return basic information for a FRED series.  Note that
this function will \emph{not} return the actual series data.  For this functionality,
see \code{\link[=fredr_series_observations]{fredr_series_observations()}}.
}
\section{API Documentation}{


\href{https://fred.stlouisfed.org/docs/api/fred/series.html}{fred/series}
}

\examples{
if (fredr_has_key()) {
# Return information for the "UNRATE" series
fredr_series(series_id = "UNRATE")
}
}
\seealso{
\code{\link[=fredr_series_observations]{fredr_series_observations()}}, \code{\link[=fredr_series_search_text]{fredr_series_search_text()}},
\code{\link[=fredr_series_search_id]{fredr_series_search_id()}}, \code{\link[=fredr_series_search_tags]{fredr_series_search_tags()}},
\code{\link[=fredr_series_search_related_tags]{fredr_series_search_related_tags()}}, \code{\link[=fredr_series_categories]{fredr_series_categories()}},
\code{\link[=fredr_series_release]{fredr_series_release()}}, \code{\link[=fredr_series_tags]{fredr_series_tags()}}, \code{\link[=fredr_series_updates]{fredr_series_updates()}},
\code{\link[=fredr_series_vintagedates]{fredr_series_vintagedates()}}.
}
