% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frailtyROC-package.R
\docType{package}
\name{frailtyROC-package}
\alias{frailtyROC-package}
\title{{frailtyROC}}
\description{
{frailtyROC is a tool for estimating and visualizing time-dependent receiver operating
             characteristic (ROC) curves, as well as the corresponding time-dependent area under the curve
             (AUC), in the context of correlated right-censored time-to-event data. Confidence bands for the ROC curve
              and confidence intervals for the AUC can be constructed using bootstrap-derived standard errors.}
}
\details{
{frailtyROC is a comprehensive tool for estimating and visualizing  time-dependent receiver operating
        characteristic (ROC) curves and their corresponding area under the curve (AUC) in the context of correlated
        right-censored time-to-event data. The ROC curves can be estimated either empirically (non-smoothed) or smoothed
        with or without boundary correction. For the latter case, the data-driven smoothing parameter selection methods
        introduced by Beyene and El Ghouch (2020) for smoothed ROC curves are implemented, offering an automatic approach
        to bandwidth selection during the smoothing process.

       The package enables the estimation of time-dependent ROC curves at specific time points to evaluate the
       discriminatory ability of prognostic models or biomarkers. The time-dependent AUC serves as a summary measure
       of predictive accuracy over time. Confidence bands for the ROC curves and confidence intervals for AUC
       estimates are obtained via non-parametric bootstrap sampling based on the percentile method. This approach yields standard
       error estimates, which serve as the basis for bootstrap-based hypothesis testing of AUC at a given time point.

       An essential component of the methodology involves estimating the survival function conditional on the observed data.
       This is accomplished through the use of shared frailty models specifically developed for correlated censored data.
       To this end, both semi-parametric and parametric frailty models are estimated using a penalized likelihood estimation
       framework that implemented in Rondeau et al. (2012). Users may specify either a gamma or log-normal frailty distribution.
       }
}
\section{Abbreviations}{
{ In this package, the following abbreviations are commonly used:
\describe{
 \item{ROC  }{Receiver Operating Characteristic curve.}
 \item{AUC  }{Area under the ROC curve at a given time horizon \code{t}.}
}
}
}

\section{Dataset}{
 {This package comes with a correlated right-censored marker data sets. For details see \code{\link{kidney}} and \code{\link{LungCancer}}
 }
}

\section{Installing and using}{

     {
   Ensure that your system has an active internet connection, then execute the following command in the R console to install the package:
      \preformatted{
                    install.packages("frailtyROC")
      }

   To load the package after installation, use the following command:
     \preformatted{
                    library(frailtyROC)
     }
   }
}

\references{
Beyene, K. M., and Chen, D. G. (2024). Time-dependent receiver operating characteristic curve estimator for correlated right-censored time-to-event data. \emph{Statistical Methods in Medical Research}, 33(1), 162-181.

Beyene, K.M. and El Ghouch A. (2020). Smoothed time-dependent receiver operating characteristic curve for right censored survival data. \emph{Statistics in Medicine}. 39: 3373-3396.

Rondeau, V., Marzroui, Y., & Gonzalez, J. R. (2012). frailtypack: an R package for the analysis of correlated survival data with frailty models using penalized likelihood estimation or parametrical estimation. \emph{Journal of Statistical Software}, 47, 1-28.
}
\author{
{
Kassu Mehari Beyene and Ding-Geng Chen

Maintainer: Kassu Mehari Beyene \code{<m2kassu@gmail.com> }
}
}
\keyword{package}
