% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.fpen}
\alias{predict.fpen}
\title{Estimate the baseline hazard or the predict hazard rate based on the new data for penalized regression}
\usage{
##S3 method for class "fpen"
}
\arguments{
\item{object}{Object with class "fpen"}

\item{tune}{The tuning parameter for estimating coefficients}

\item{coef}{Instead of providing tuning parameter, you can directly provide the coefficients for prediction}

\item{newdata}{The new data for prediction of hazard, categorical data has to be transformed to 0 and 1}

\item{surv}{Plot survival curve instead of cumulative hazard, the default is \code{FALSE}}

\item{...}{Further arguments pass to or from other methods}
}
\value{
\item{output}{A dataframe that the first column is the evaluated time point and the second column is the estimated cumulative
hazard or survival curve.}
}
\description{
This function is used to estimate the baseline hazard or to predict the hazard rate of a specific individual
given result from model fitting.
}
\details{
If parameter \code{newdata} is given, the predicted hazard is calculated based on the given data.
If parameter \code{newdata} is not given, the estimation of baseline hazard will be returned. 
Since the covariance of estimated parameters for penalized regression cannot be obtained from MLE theorem, we
only provide the estimation without confidence band. For the formulation of new data, you may refer to
function \code{predict.fmm} for detailed description.
}
\examples{
 
data(simdataCL)

\donttest{
gam_cl = frailtyMMpen(Surv(time, status) ~  . + cluster(id), simdataCL, frailty = "Gamma")

# Calculate the survival curve based on baseline hazard
predict(gam_cl, surv = TRUE)

# Construct new data and calculate the cumulative hazard based on new data
newcl = c(gam_cl$X[1,], 2)
names(newcl) = c(gam_cl$coefname, "id")
predict(gam_cl, newdata = newcl)
}
}
