% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fracdist.R
\name{get_fracdist_tab}
\alias{get_fracdist_tab}
\title{Obtain Lookup Tables of Probabilities and Quantiles}
\usage{
get_fracdist_tab(iq, iscon, dir_name = NULL, file_ext = "rda")
}
\arguments{
\item{iq}{An integer scalar rank parameter for the test, from 1 through 12.
This is often the difference in cointegration rank.}

\item{iscon}{An indicator that there is a constant intercept
term in the model.}

\item{dir_name}{A string name of directory in which the tables
are stored. This is not normally used, however, a user might want to
draw the tables from another location.}

\item{file_ext}{A string extension indicating the file format of
the tables. The default is \code{'rda'}, which is the format of
the tables included in the package. The tables may also be stored in
\code{'RData'} format. The tables accompanying the
original Fortran program, on which this package is based,
can be obtained in \code{'txt'} format. See the reference for details.}
}
\value{
A data frame with three columns: \code{bbb} is the fractional
integration parameter, \code{probs} are the probability values,
and \code{xndf} is the \code{probs} quantile of the distribution.
}
\description{
\code{get_fracdist_tab} selects a table of probabilities
and quantiles for a list of values of the fractional
integration parameter, corresponding to a particular rank
or dimension and the specification of a constant term.
}
\examples{
frtab <- get_fracdist_tab(iq = 1, iscon = 0)
}
\references{
James G. MacKinnon and Morten \enc{Ø}{O}rregaard Nielsen,
"Numerical Distribution Functions of Fractional Unit Root and Cointegration Tests,"
\emph{Journal of Applied Econometrics}, Vol. 29, No. 1, 2014, pp.161-171.
}
