% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taub.R
\name{taub}
\alias{taub}
\title{Calculate Kendall's (1938) Tau-B}
\usage{
taub(x1, x2)
}
\arguments{
\item{x1}{a vector, and one assumes an integer}

\item{x2}{a vector, and one assumes an integer}
}
\value{
\code{taub()} takes two vectors and returns Kendall's Tau-b as a measure of
rank correlation.
}
\description{
\code{taub()} takes two vectors and returns Kendall's Tau-b as a measure of
rank correlation.
}
\details{
I'll be honest that I wrote this just to say that I did write this and that
my workflow would still lean on using the \code{\link[=cor]{cor()}} function in base R.
}
\examples{

taub(usamex46$vote1, usamex46$vote2)
taub(gmyrus14$gmy, gmyrus14$rus)

# Compare with...

cor(usamex46$vote1, usamex46$vote2, method = 'kendall')
cor(gmyrus14$gmy, gmyrus14$rus, method = 'kendall')

}
\references{
Kendall, Maurice G. 1938. "A New Measure of Rank Correlation". \emph{Biometrika}
30(1/2): 81-93.
}
