% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FG_Server.R
\name{FG_append_report}
\alias{FG_append_report}
\title{Append Report Elements}
\usage{
FG_append_report(state, rpt, rpttype, gen_code_only = FALSE)
}
\arguments{
\item{state}{FG state from \code{FG_fetch_state()}}

\item{rpt}{Report with the current content of the report which will be appended to in
this function. For details on the structure see the documentation for \code{\link{FM_generate_report}}.}

\item{rpttype}{Type of report to generate (supported "xlsx", "pptx", "docx").}

\item{gen_code_only}{Boolean value indicating that only code should be
generated (\code{FALSE}).}
}
\value{
list containing the following elements
\itemize{
 \item{isgood:}    Return status of the function.
 \item{hasrptele:} Boolean indicator if the module has any reportable elements.
 \item{code:}      Data wrangling R command.
 \item{msgs:}      Messages to be passed back to the user.
 \item{rpt:}       Report with any additions passed back to the user.
}
}
\description{
Description
}
\examples{
\donttest{
sess_res = FG_test_mksession()
state = sess_res$state
# This will read in the default PowerPoint report template
rpt =
onbrand::read_template(
 template = system.file(package="onbrand","templates","report.pptx"),
 mapping  = system.file(package="onbrand","templates","report.yaml"))

rpt_res =
FG_append_report(state   = state,    rpt = rpt,
                 rpttype = "pptx", gen_code_only=TRUE)

# Shows if report elements are present
rpt_res$hasrptele

# Code chunk to generate report element
cat(paste(rpt_res$code, collapse="\n"))
}
}
\seealso{
\code{\link{FM_generate_report}}
}
