% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BdW.R
\name{BdW}
\alias{BdW}
\title{Beta discrete Weibull (BdW) Model for Projecting Customer Retention.}
\usage{
BdW(surv_value, h, lower = c(0.001, 0.001, 0.001), upper = c(10000,
  10000, 10000))
}
\arguments{
\item{surv_value}{a numeric vector of historical customer retention percentage should start at 100 and non-starting values should be between 0 and less than 100}

\item{h}{forecasting horizon}

\item{lower}{lower limit used in \code{R} \code{optim} rotuine. Default is \code{c(1e-3,1e-3)}.}

\item{upper}{upper limit used in \code{R} \code{optim} rotuine. Default is \code{c(10000,10000,10000)}.}
}
\value{
\item{fitted:}{Fitted values based on historical data}
\item{projected:}{Projected \code{h} values based on historical data}
\item{max.likelihood:}{Maximum Likelihood of Beta discrete Weibull}
\item{params - a, b and c:}{Returns a and b paramters from maximum likelihood estimation for beta distribution and c}
}
\description{
\code{BdW} is a beta discrete weibull model implemented based on \code{Fader and Hardie} probability based projection methedology. The survivor function for \code{BdW} is \deqn{Beta(a,b+t^c)/Beta(a,b)}
}
\examples{
surv_value <- c(100,86.9,74.3,65.3,59.3)
h <- 6
BdW(surv_value,h)

}
\references{
{Fader P, Hardie B. How to project customer retention. Journal of Interactive Marketing. 2007;21(1):76-90.}

{Fader P, Hardie B, Liu Y, Davin J, Steenburgh T. "How to Project Customer Retention" Revisited: The Role of Duration Dependence. Journal of Interactive Marketing. 2018;43:1-16.}
}
