% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLRs.R
\name{plotLR}
\alias{plotLR}
\title{Plot Weighted Distribution of Log10(LR)}
\usage{
plotLR(data)
}
\arguments{
\item{data}{A dataframe that must contain the columns 'LR', 'numerators', and 'f_h_s_y'.}
}
\value{
A ggplot object showing the weighted density plot.
}
\description{
This function plots the weighted distribution of the log10 of likelihood ratios (LR),
using the probabilities provided in 'numerators' for H1 and 'f_h_s_y' for H2 as weights.
The densities are shown for two hypotheses, H1 and H2.
}
\examples{
data <- forensicolors::simRef()
conditioned <- conditionedProp(data, 1, 1, 1, 0.01, 0.01, 0.01)
unconditioned <- forensicolors::refProp(data)
likelihoods <- forensicolors::compute_LRs(conditioned, unconditioned)
plotLR(likelihoods)
}
