% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_cards_data.R
\name{bind_cards_data}
\alias{bind_cards_data}
\title{Bind cards data}
\usage{
bind_cards_data(
  .,
  cards_data = NULL,
  title = NULL,
  image = NULL,
  category = NULL,
  subtitle = NULL,
  text = NULL,
  audio = NULL,
  filter = NULL,
  metadata = NULL,
  audio_input_format = NULL,
  audio_output_format = NULL,
  category_input_format = NULL,
  category_output_format = NULL,
  filter_input_format = NULL,
  filter_output_format = NULL,
  image_input_format = NULL,
  image_output_format = NULL,
  metadata_input_format = NULL,
  metadata_output_format = NULL,
  subtitle_input_format = NULL,
  subtitle_output_format = NULL,
  text_input_format = NULL,
  text_output_format = NULL,
  title_input_format = NULL,
  title_output_format = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{cards_data}{Cards data.}

\item{title}{Title. Suggested data type hints: string. Flourish type hint: column}

\item{image}{Image. Suggested data type hints: string. Flourish type hint: column}

\item{category}{Categories. Optional category column to color the cards. Suggested data type hints: string. Flourish type hint: column}

\item{subtitle}{Subtitle. Suggested data type hints: string. Flourish type hint: column}

\item{text}{Text. Suggested data type hints: string. Flourish type hint: columns}

\item{audio}{Audio. Add an audio file to the card, which will play when the card is clicked. This will disable popup behavior. Suggested data type hints: string. Flourish type hint: column}

\item{filter}{Filter. Suggested data type hints: string, number, datetime. Flourish type hint: column}

\item{metadata}{Info for popups. One or more columns of information (text, image URLs, embedded charts etc) to include in custom popups and panelsSuggested data type hints: string, number, datetime. Flourish type hint: columns}

\item{audio_input_format}{Formats/parses dates, strings, and numbers for the audio column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{audio_output_format}{Formats/parses dates, strings, and numbers for the audio column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{category_input_format}{Formats/parses dates, strings, and numbers for the category column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{category_output_format}{Formats/parses dates, strings, and numbers for the category column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{filter_input_format}{Formats/parses dates, strings, and numbers for the filter column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{filter_output_format}{Formats/parses dates, strings, and numbers for the filter column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{image_input_format}{Formats/parses dates, strings, and numbers for the image column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{image_output_format}{Formats/parses dates, strings, and numbers for the image column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{metadata_input_format}{Formats/parses dates, strings, and numbers for the metadata column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{metadata_output_format}{Formats/parses dates, strings, and numbers for the metadata column. If string: any arbritrary string. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{subtitle_input_format}{Formats/parses dates, strings, and numbers for the subtitle column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{subtitle_output_format}{Formats/parses dates, strings, and numbers for the subtitle column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{text_input_format}{Formats/parses dates, strings, and numbers for the text column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{text_output_format}{Formats/parses dates, strings, and numbers for the text column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{title_input_format}{Formats/parses dates, strings, and numbers for the title column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{title_output_format}{Formats/parses dates, strings, and numbers for the title column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}
}
\value{
A Flourish chart
}
\description{
Bind cards data
}
\examples{
try(
  flourish(chart_type = "cards", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_cards_data(gapminder)
)
}
