% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind_bar_chart_race_data.R
\name{bind_bar_chart_race_data}
\alias{bind_bar_chart_race_data}
\title{Bind bar chart race data}
\usage{
bind_bar_chart_race_data(
  .,
  data = NULL,
  captions_data = NULL,
  label = NULL,
  values = NULL,
  category = NULL,
  image = NULL,
  captions_from = NULL,
  captions_to = NULL,
  captions_text = NULL,
  captions_image = NULL,
  captions_image_input_format = NULL,
  captions_image_output_format = NULL,
  captions_text_input_format = NULL,
  captions_text_output_format = NULL,
  captions_to_input_format = NULL,
  captions_to_output_format = NULL,
  captions_from_input_format = NULL,
  captions_from_output_format = NULL,
  category_input_format = NULL,
  category_output_format = NULL,
  image_input_format = NULL,
  image_output_format = NULL,
  label_input_format = NULL,
  label_output_format = NULL,
  values_input_format = NULL,
  values_output_format = NULL
)
}
\arguments{
\item{.}{The prior Flourish object. No need to specify name if piping graph as the graph will take the first argument (i.e. the prior existing graph).}

\item{data}{Data.}

\item{captions_data}{Captions data.}

\item{label}{Label. A column containing the names of the bars, e.g. countries or people. Suggested data type hints: string. Flourish type hint: column}

\item{values}{Values. Multiple columns of numbers, each column representing a point in time Suggested data type hints: number. Flourish type hint: columns}

\item{category}{Categories. Optional category column to color the bars Make sure the Color mode setting is set to By Category in the Bar colors settings panel. Suggested data type hints: string. Flourish type hint: column}

\item{image}{Image. Optional column with URLs of images. Suggested data type hints: string. Flourish type hint: column}

\item{captions_from}{Time to show. Must match the column headers in the main data sheet. Suggested data type hints: string, datetime. Flourish type hint: column}

\item{captions_to}{Time to hide. Must match the column headers in the main data sheet. Suggested data type hints: string, datetime. Flourish type hint: column}

\item{captions_text}{Text. Text or HTML to show. Suggested data type hints: string. Flourish type hint: column}

\item{captions_image}{Image. Image to show. Add an image URL or right-click on a cell to upload an image. Suggested data type hints: string. Flourish type hint: column}

\item{captions_image_input_format}{Formats/parses dates, strings, and numbers for the image column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{captions_image_output_format}{Formats/parses dates, strings, and numbers for the image column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{captions_text_input_format}{Formats/parses dates, strings, and numbers for the text column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{captions_text_output_format}{Formats/parses dates, strings, and numbers for the text column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{captions_to_input_format}{Formats/parses dates, strings, and numbers for the to column. If string: any arbritrary string. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{captions_to_output_format}{Formats/parses dates, strings, and numbers for the to column. If string: any arbritrary string. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{captions_from_input_format}{Formats/parses dates, strings, and numbers for the from column. If string: any arbritrary string. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{captions_from_output_format}{Formats/parses dates, strings, and numbers for the from column. If string: any arbritrary string. If date-time: A date-time format such as "\%Y-\%m-\%dT\%H:\%M:\%S.\%LZ", "\%d/\%m/\%Y", "\%d \%b", "\%-I\%p", "Q\%q \%Y", "\%Y Q\%q", and so on. All available formats noted in Flourish documentation: \url{https://developers.flourish.studio/api/create-visualisation/}.. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{category_input_format}{Formats/parses dates, strings, and numbers for the category column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{category_output_format}{Formats/parses dates, strings, and numbers for the category column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{image_input_format}{Formats/parses dates, strings, and numbers for the image column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{image_output_format}{Formats/parses dates, strings, and numbers for the image column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{label_input_format}{Formats/parses dates, strings, and numbers for the label column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{label_output_format}{Formats/parses dates, strings, and numbers for the label column. If string: any arbritrary string. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{values_input_format}{Formats/parses dates, strings, and numbers for the values column. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}

\item{values_output_format}{Formats/parses dates, strings, and numbers for the values column. If number: 'comma_point', 'space_point', 'point_comma', 'space_comma', 'none_point', 'none_comma'. Note: column metadata is optional, and the API will interpret your data for you if you do not specify it. A typical example of when specifying metadata can be useful is when column(s) in your data contain numbers or dates that you wish to format visually (e.g. to display a column containing MM/DD/YYYY dates in DD/MM/YYYY format).}
}
\value{
A Flourish chart
}
\description{
Bind bar chart race data
}
\examples{
try(
  flourish(chart_type = "bar_race", api_key = Sys.getenv("FLOURISH_API_KEY")) |> 
  bind_bar_chart_race_data(gapminder)
)
}
