% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_evi.R
\name{RegioWeissmanSeas}
\alias{RegioWeissmanSeas}
\title{Quantile estimation: Weissman's extrapolation for seasonal data}
\usage{
RegioWeissmanSeas(x, j = 1, p, ...)
}
\arguments{
\item{x}{List of 2 elements: each element is consistent a vector or matrix of observations}

\item{j}{The number of the target site, i.e., if \code{j=2} the p-quantile of the second station is estimated.}

\item{p}{The probability of interest; should be between \eqn{1-k_j/n_j} and 1, where \eqn{n_j} is the
sample length of the \code{j}-th column.}

\item{...}{additional arguments, see \link{RegioWeissman}}
}
\value{
Point estimate of seasonal p-quantile of column \code{j} and a short description.
}
\description{
Estimation of the p-quantile based on multiple local Hill estimators and Weissman's extrapolation
formula with seasonality. We assume heavy-tail homogeneity within each season, i.e., all local EVI's are the same.
}
\examples{
library("evd")
# Local & seasonal (observations of 80 years at one station):
x1 <- rgev(80, 2, 1, 0.2) # observations from season 1
x2 <- rgev(80, 3, 1, 0.3) # observations from season 2
x <- list(x1, x2)
RegioWeissmanSeas(x=x, j=1, p=0.99)

x1 <- matrix(rgev(400, 3, 1, 0.1), ncol=4) # observations of season 1 at 4 stations
x2 <- matrix(rgev(400, 2, 1, 0.3), ncol=4) # observations of season 2 at 4 stations
x <- list(x1, x2)
RegioWeissmanSeas(x=x, j=1, p=0.99)
}

