% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_flocker_data.R
\name{make_flocker_data_static}
\alias{make_flocker_data_static}
\title{Format data for single-season occupancy model, to be passed to 
 \code{flock()}.}
\usage{
make_flocker_data_static(
  obs,
  unit_covs = NULL,
  event_covs = NULL,
  quiet = FALSE
)
}
\arguments{
\item{obs}{An I x J matrix-like object where closure is assumed across rows 
and columns are repeated sampling events. Allowable values are 1 (detection), 
0 (no detection), and NA (no sampling event).}

\item{unit_covs}{A dataframe of covariates for each unit that are constant 
across repeated sampling events within closure-units.}

\item{event_covs}{A named list of I x J matrices, each one corresponding to a covariate
that varies across repeated sampling events within closure-units}

\item{quiet}{Hide progress bars and informational messages?}
}
\value{
A flocker_data list that can be passed as data to \code{flock()}.
}
\description{
Format data for single-season occupancy model, to be passed to 
 \code{flock()}.
}
\examples{
sfd <- simulate_flocker_data()
make_flocker_data_static(
 sfd$obs, 
 sfd$unit_covs,
 sfd$event_covs
)
}
