% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flxregmultinom.R
\name{FLXMCregmultinom}
\alias{FLXMCregmultinom}
\title{FlexMix Driver for Regularized Multinomial Mixtures}
\usage{
FLXMCregmultinom(formula = . ~ ., r = NULL, alpha = 0)
}
\arguments{
\item{formula}{A formula which is interpreted relative to the
formula specified in the call to \code{\link[flexmix:flexmix]{flexmix::flexmix()}} using
\code{\link[stats:update.formula]{stats::update.formula()}}. Only the left-hand side (response)
of the formula is used. Default is to use the original model
formula specified in \code{\link[flexmix:flexmix]{flexmix::flexmix()}}.}

\item{r}{Number of different categories. Values are assumed to be
integers in \code{1:r}. Default \code{NULL} implies that the number of
different categories is inferred columnwise by the maximum
value observed.}

\item{alpha}{A non-negative scalar acting as regularization
parameter. Can be regarded as adding \code{alpha} observations equal
to the population mean to each component.}
}
\value{
An object of class \code{"FLXC"}.
}
\description{
This model driver can be used to cluster data using a multinomial
distribution.
}
\details{
Using a regularization parameter \code{alpha} greater than zero
acts as adding \code{alpha} observations conforming to the population
mean to each component. This can be used to avoid degenerate
solutions. It also has the effect
that clusters become more similar to each other the larger
\code{alpha} is chosen. For small values it is mostly negligible however.

For regularization we compute the MAP estimates for the multinomial
distribution using the Dirichlet distribution as prior, which is
the conjugate prior. The parameters of this prior are selected to
correspond to the marginal distribution of the variable across all
observations.
}
\examples{
library("flexmix")
library("flexord")
library("flexclust")


set.seed(0xdeaf)

# Sample data
k <- 4     # nr of clusters
nvar <- 10  # nr of variables
r <- sample(2:7, size=nvar, replace=TRUE)  # nr of categories
N <- 100   # obs. per cluster


# random probabilities per component
probs <- lapply(seq_len(k), \(ki) runif(nvar, 0.01, 0.99))

# sample data by drawing from a binomial distribution with size = r - 1
# values are expect values to lie inside 1:r hence we add +1.
dat <- lapply(probs, \(p) {
    mapply(\(p_i, r_i) {
        rbinom(N, r_i, p_i) + 1
    }, p, r-1, SIMPLIFY=FALSE) |> do.call(cbind, args=_)
}) |> do.call(rbind, args=_)

true_clusters <- rep(1:4, rep(N, k))

# Cluster without regularization
m1 <- stepFlexmix(dat~1, model=FLXMCregmultinom(r=r, alpha=0), k=k)

# Cluster with regularization
m2 <- stepFlexmix(dat~1, model=FLXMCregmultinom(r=r, alpha=1), k=k)

# Both models are mostly able to reconstruct the true clusters (ARI ~ 0.95)
# (it's a very easy clustering problem)
# Small values for the regularization don't seem to affect the ARI (much)
randIndex(clusters(m1), true_clusters)
randIndex(clusters(m2), true_clusters)
}
\references{
\itemize{
\item Galindo Garre, F, Vermunt, JK (2006).  \emph{Avoiding
Boundary Estimates in Latent Class Analysis by Bayesian
Posterior Mode Estimation} Behaviormetrika, 33, 43-59.  -
Ernst, D, Ortega Menjivar, L, Scharl, T, Grün, B (2025).
\emph{Ordinal Clustering with the flex-Scheme.} Austrian Journal of
Statistics. \emph{Submitted manuscript}.
}
}
