% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data.R
\name{sim_data}
\alias{sim_data}
\title{Simulate FMP Data}
\usage{
sim_data(bmat, theta, maxncat = 2, cvec = NULL, dvec = NULL)
}
\arguments{
\item{bmat}{Matrix of FMP item parameters.}

\item{theta}{Vector of latent trait values.}

\item{maxncat}{Maximum number of response categories  (the first maxncat - 1
columns of bmat are intercepts)}

\item{cvec}{Optional vector of lower asymptote parameters. If cvec = NULL,
then all lower asymptotes set to 0.}

\item{dvec}{Optional vector of upper asymptote parameters. If dvec = NULL,
then all upper asymptotes set to 1.}
}
\value{
Matrix of randomly generated binary item responses.
}
\description{
Simulate data according to user-specified FMP item parameters and
latent trait parameters.
}
\examples{

## generate 5-category item responses for normally distributed theta
##   and 5 items with k = 2

set.seed(2342)
bmat <- sim_bmat(n_items = 5, k = 2, ncat = 5)$bmat

theta <- rnorm(50)
dat <- sim_data(bmat = bmat, theta = theta, maxncat = 5)

}
