% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitbit_utils.R
\name{sleep_time_series}
\alias{sleep_time_series}
\title{Sleep Data Time Series}
\usage{
sleep_time_series(
  user_id,
  token,
  date_start,
  date_end,
  ggplot_color_palette = "ggsci::blue_material",
  ggplot_ncol = NULL,
  ggplot_nrow = NULL,
  show_nchar_case_error = 135,
  verbose = FALSE
)
}
\arguments{
\item{user_id}{a character string specifying the encoded ID of the user. For instance '99xxxx' of the following URL 'https://www.fitbit.com/user/99xxxx' of the user's account corresponds to the 'user_id'}

\item{token}{a character string specifying the secret token that a user receives when registers a new application in https://dev.fitbit.com/apps}

\item{date_start}{a character string specifying the start Date for which the sleep data should be returned. For instance, the date '2021-12-31' where the input order is 'year-month-day'}

\item{date_end}{a character string specifying the end Date for which the sleep data should be returned. For instance, the date '2021-12-31' where the input order is 'year-month-day'}

\item{ggplot_color_palette}{a character string specifying the color palette to be used. For a full list of palettes used in the ggplot see:  https://pmassicotte.github.io/paletteer_gallery/ The following color-palettes were tested and work well: "rcartocolor::Purp", "rcartocolor::Teal"}

\item{ggplot_ncol}{either NULL or an integer specifying the number of columns of the output ggplot}

\item{ggplot_nrow}{either NULL or an integer specifying the number of rows of the output ggplot}

\item{show_nchar_case_error}{an integer that specifies the number of characters that will be returned in case on an error. The default value is 135 characters.}

\item{verbose}{a boolean. If TRUE then information will be printed out in the console}
}
\value{
an object of class list
}
\description{
Sleep Data Time Series
}
\examples{

\dontrun{

require(fitbitViz)

#.........................................
# first compute the sleep time time series
#.........................................

USER_ID = '99xxxx'
token = 'my_long_web_api_token'

sleep_ts = sleep_time_series(user_id = USER_ID,
                             token = token,
                             date_start = '2021-03-09',
                             date_end = '2021-03-16',
                             ggplot_color_palette = 'ggsci::blue_material',
                             show_nchar_case_error = 135,
                             verbose = TRUE)

sleep_ts$plt_lev_segments
sleep_ts$plt_lev_heatmap
sleep_ts$heatmap_data


#...........................................
# (option to) save the ggplot to a .png file
#...........................................

png_file = tempfile(fileext = '.png')

ggplot2::ggsave(filename = png_file,
                plot = sleep_ts$plt_lev_segments,
                device = 'png',
                scale = 1,
                width = 35,
                height = 25,
                limitsize = TRUE)
}
}
