% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitPolyTools.R
\name{XY_plot}
\alias{XY_plot}
\title{Draws an XY-plot showing allele signals and assigned dosages}
\usage{
XY_plot(title="", XYdat, shift=0, ploidy=NULL,
genocol="grey", pch=1, cex=1,
sel.samples=as.character(unique(XYdat$SampleName)), omit.pch=".",
omit.col=NULL, sample.groups=list(), groups.col="black", groups.pch=1,
groups.cex=1, groups.rnd=FALSE, R.thresholds=NA, R.col="black", R.lty=1)
}
\arguments{
\item{title}{the main title above the plot}

\item{XYdat}{a data frame with at least columns SampleName, X and Y;
column geno (if present) is also used. Contains data for all samples, one SNP.
geno is the dosage (0 .. <ploidy>), with NA or <ploidy+1> for missing dosage
info}

\item{shift}{a single integer, default 0: by how much should the geno
be shifted?}

\item{ploidy}{a single integer specifying the ploidy; default NA, only
needed if there is a column geno in XYdat}

\item{genocol}{a vector of color values to be used for plotting
the sel.samples according on their geno (dosage) value; if only one value is
given (default) all samples are plotted in that color}

\item{pch}{the plot character to plot the sel.samples; default 1 is an
open circle}

\item{cex}{the relative size of the sample symbols}

\item{sel.samples}{character vector (not a factor) with the names of the
important samples: those that must be plotted in colors genocol and symbol pch}

\item{omit.pch}{the plot character to use for the other samples, default a dot}

\item{omit.col}{vector of two colors to use for the other samples; the first
color is used for sample with a geno (dosage) value, the second color for
unscored samples; recycled if needed, with NA (default) the non-selected
samples are not plotted}

\item{sample.groups}{a list specifying samples to be highlighted in a
different color and/or symbol and/or size. For each group of samples the list
has one vector of sample names; the list may also be empty}

\item{groups.col}{a vector or color values, one for each item (vector of
sample names) in sample.groups; recycled if shorter than sample.groups}

\item{groups.pch}{a vector of plot symbols, one for each item in
sample.groups; recycled if shorter than sample.groups}

\item{groups.cex}{a vector of relative symbol sizes, one for each item in
sample.groups; recycled if shorter than sample.groups}

\item{groups.rnd}{FALSE (default) or TRUE. If FALSE, all samples in
sample.groups are drawn in the order in which they appear in XYdat; if TRUE
they are drawn in a random order. Note that the samples are never drawns in
group order (except is the samples are already in group order in XYdat and
groups.rnd=FALSE).}

\item{R.thresholds}{a vector of thresholds for R to plot; is NA (default)
no R thresholds are plotted}

\item{R.col}{a vector of color values for drawing R thresholds, one for
each value of R.thresholds; recycled if needed}

\item{R.lty}{a vector of line types for drawing the R thresholds, one for
each value of R.thresholds; recycled if needed}
}
\value{
The function produces an XY-plot and returns NULL
}
\description{
Draws an XY-plot for one markers showing the X and Y signals
of each sample and their assigned dosages
}
