% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fish_pallette.R
\name{scale_color_fish}
\alias{scale_color_fish}
\alias{scale_colour_fish}
\alias{scale_colour_fish_d}
\alias{scale_color_fish_d}
\alias{scale_fill_fish_d}
\alias{scale_fill_fish}
\title{fish colour scales}
\usage{
scale_color_fish(
  option = "Centropyge_loricula",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE
)

scale_colour_fish(
  option = "Centropyge_loricula",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE
)

scale_colour_fish_d(
  option = "Centropyge_loricula",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1
)

scale_color_fish_d(
  option = "Centropyge_loricula",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1
)

scale_fill_fish_d(
  option = "Centropyge_loricula",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1
)

scale_fill_fish(
  option = "Centropyge_loricula",
  ...,
  alpha = 1,
  begin = 0,
  end = 1,
  direction = 1,
  discrete = FALSE
)
}
\arguments{
\item{option}{A character string indicating the fish species to use.}

\item{...}{parameters to \code{discrete_scale} or \code{scale_fill_gradientn}}

\item{alpha}{pass through parameter to \code{fish}}

\item{begin}{The (corrected) hue in [0,1] at which the fish colormap begins.}

\item{end}{The (corrected) hue in [0,1] at which the fish colormap ends.}

\item{direction}{Sets the order of colors in the scale. If 1, the default, colors
are as output by \code{fish_pal}. If -1, the order of colors is reversed.}

\item{discrete}{generate a discrete palette? (default: \code{FALSE} - generate continuous palette)}
}
\value{
Alias of scale_color_fish or scale_fill_fish

Alias of scale_color_fish or scale_fill_fish

Alias of scale_color_fish or scale_fill_fish

Alias of scale_color_fish or scale_fill_fish

Alias of scale_color_fish or scale_fill_fish
}
\description{
Uses the fish color scale.
}
\details{
For \code{discrete == FALSE} (the default) all other arguments are as to
\link[ggplot2]{scale_fill_gradientn} or \link[ggplot2]{scale_color_gradientn}.
Otherwise the function will return a \code{discrete_scale} with the plot-computed
number of colors.
}
\examples{
library(ggplot2)
library(fishualize)


ggplot(diamonds, aes(factor(cut), fill=factor(cut))) +
geom_bar() +
scale_fill_fish(discrete = TRUE, option = "Centropyge_loricula")

ggplot(mtcars, aes(factor(gear), fill=factor(carb))) +
geom_bar() +
scale_fill_fish(discrete = TRUE, option = "Trimma_lantana")

ggplot(mtcars, aes(x = mpg, y = disp, colour = drat)) +
geom_point(size = 4) +
scale_colour_fish(option = "Ostracion_cubicus", direction = -1)




}
