% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{filter_peaks}
\alias{filter_peaks}
\title{Filter Peaks from K-mer Histogram}
\usage{
filter_peaks(peaks, histo)
}
\arguments{
\item{peaks}{A data frame containing the peaks from the histogram.}

\item{histo}{A data frame representing the k-mer histogram.}
}
\value{
A data frame with filtered peaks.
}
\description{
This function filters peaks from a k-mer histogram to find a major peak with enough support information on both sides.
}
\examples{
peaks <- data.frame(V1=1:20, V2=sample(1:10, 20, replace=TRUE))
histo <- data.frame(V1=1:100, V2=sample(1:10, 100, replace=TRUE))
filtered_peaks <- filter_peaks(peaks, histo)
print(filtered_peaks)
}
