% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters.R
\name{apply_filter}
\alias{apply_filter}
\alias{apply_filter.default}
\alias{apply_filter.data.frame}
\alias{apply_filter.list}
\title{Apply a Filter to a Dataset or List of Datasets}
\usage{
apply_filter(data, ...)

\method{apply_filter}{default}(data, ...)

\method{apply_filter}{data.frame}(data, id, target = deparse(substitute(data)), verbose = TRUE, ...)

\method{apply_filter}{list}(data, id, verbose = TRUE, ...)
}
\arguments{
\item{data}{\code{data.frame} of \code{list} of \code{data.frame}s}

\item{...}{Not used.}

\item{id}{\code{character}. The ID of a filter defined with \code{add_filter()}}

\item{target}{\code{character}. The name of the dataset, e.g. ADSL or ADTTE}

\item{verbose}{\code{logical}. Should informative messages be printed? Defaults to \code{TRUE}.}
}
\value{
A new \code{data.frame} or \code{list} of \code{data.frame}s filtered based upon the condition defined for \code{id}
}
\description{
Apply a Filter to a Dataset or List of Datasets
}
\examples{
adsl <- random.cdisc.data::cadsl
adae <- random.cdisc.data::cadae
datasets <- list(adsl = adsl, adae = adae)

add_filter("REL", "Related AEs", "ADAE", AEREL == "Y", overwrite = TRUE)

apply_filter(adsl, "SE")
apply_filter(adae, "SER_REL")
apply_filter(datasets, "SER_REL_SE")

}
\author{
Thomas Neitmann (\code{neitmant})
}
