% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repr.R
\name{add_cplx}
\alias{add_cplx}
\alias{add_rect}
\alias{add_polr}
\title{Add Additional Representations to Fourier Coefficients}
\usage{
add_cplx(x)

add_rect(x)

add_polr(x)
}
\arguments{
\item{x}{A \code{fftab} object containing Fourier coefficients and associated metadata.}
}
\value{
A \code{fftab} object with the additional representation included.
}
\description{
These functions add additional representations to a \code{fftab} object without removing or modifying existing representations.
}
\details{
\itemize{
\item \strong{\code{add_cplx()}}: Adds a \strong{complex} (\code{"cplx"}) representation to the Fourier coefficients.
\item \strong{\code{add_rect()}}: Adds a \strong{rectangular} (\code{"rect"}) representation to the Fourier coefficients.
\item \strong{\code{add_polr()}}: Adds a \strong{polar} (\code{"polr"}) representation to the Fourier coefficients.
}

These functions are useful for working with multiple representations simultaneously without overwriting existing data.
}
\examples{
matrix(1:9, 3) |>
  fftab() |>
  print(n = 3) |>
  add_polr() |>
  print(n = 3) |>
  add_rect() |>
  print(n = 3) |>
  add_cplx() |>
  print(n = 3)

}
\seealso{
\itemize{
\item \code{\link[=fftab]{fftab()}}
}
}
