% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_transactions.R,
%   R/flea_transactions.R, R/mfl_transactions.R, R/sleeper_transactions.R
\name{ff_transactions}
\alias{ff_transactions}
\alias{ff_transactions.espn_conn}
\alias{ff_transactions.flea_conn}
\alias{ff_transactions.mfl_conn}
\alias{ff_transactions.sleeper_conn}
\title{Get League Transactions}
\usage{
ff_transactions(conn, ...)

\method{ff_transactions}{espn_conn}(conn, limit = 1000, ...)

\method{ff_transactions}{flea_conn}(conn, franchise_id = NULL, ...)

\method{ff_transactions}{mfl_conn}(conn, transaction_type = "*", ...)

\method{ff_transactions}{sleeper_conn}(conn, week = 1:17, ...)
}
\arguments{
\item{conn}{the list object created by \code{ff_connect()}}

\item{...}{additional args for other methods}

\item{limit}{number of most recent transactions to return}

\item{franchise_id}{fleaflicker returns transactions grouped by franchise id, pass a list here to filter}

\item{transaction_type}{parameter to return transactions of the specified type. Types are: \code{WAIVER}, \code{BBID_WAIVER}, \code{FREE_AGENT}, \code{TRADE}, \code{IR}, \code{TAXI}, \code{AUCTION_INIT}, \code{AUCTION_BID}, \code{AUCTION_WON}, or \code{*} for all. Can also pass a comma-separated string.  Defaults to \code{*}. Note that only the types listed above are actually cleaned and processed by ffscrapr - you will need to make a custom api request with \code{mfl_getendpoint()} to receive other things.}

\item{week}{A week filter for transactions - 1 returns all offseason transactions. Default 1:17 returns all transactions.}
}
\value{
A tidy dataframe of transaction data
}
\description{
This function returns a tidy dataframe of transactions - generally one row per player per transaction per team.
Each trade is represented twice, once per each team.
}
\section{Methods (by class)}{
\itemize{
\item \code{ff_transactions(espn_conn)}: ESPN: returns adds, drops, and trades. Requires private/auth-cookie.

\item \code{ff_transactions(flea_conn)}: Fleaflicker: returns all transactions, including free agents, waivers, and trades.

\item \code{ff_transactions(mfl_conn)}: MFL: returns all transactions, including auction, free agents, IR, TS, waivers, and trades.

\item \code{ff_transactions(sleeper_conn)}: Sleeper: returns all transactions, including free agents, waivers, and trades.

}}
\examples{
\dontrun{
# Marked as don't run because this endpoint requires private authentication

conn <- espn_connect(
  season = 2020,
  league_id = 1178049,
  swid = Sys.getenv("TAN_SWID"),
  espn_s2 = Sys.getenv("TAN_ESPN_S2")
)
ff_transactions(conn)
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- fleaflicker_connect(season = 2020, league_id = 312861)
  ff_transactions(conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  dlf_conn <- mfl_connect(2019, league_id = 37920)
  ff_transactions(dlf_conn)
}) # end try
}
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  jml_conn <- ff_connect(platform = "sleeper", league_id = "522458773317046272", season = 2020)
  ff_transactions(jml_conn, week = 1:2)
}) # end try
}

}
