% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting_periods.R
\name{get_reporting_periods}
\alias{get_reporting_periods}
\alias{get_ubpr_reporting_periods}
\title{Retrieve Reporting Periods}
\usage{
get_reporting_periods(
  user_id = Sys.getenv("FFIEC_USER_ID"),
  bearer_token = Sys.getenv("FFIEC_BEARER_TOKEN"),
  as_data_frame = FALSE
)

get_ubpr_reporting_periods(
  user_id = Sys.getenv("FFIEC_USER_ID"),
  bearer_token = Sys.getenv("FFIEC_BEARER_TOKEN"),
  as_data_frame = FALSE
)
}
\arguments{
\item{user_id}{(String) The UserID for authenticating against the FFIEC API}

\item{bearer_token}{(String) The Bearer Token for authenticating against the
FFIEC API}

\item{as_data_frame}{(Logical) Should the result be returned as a tibble?
Default is \code{FALSE}.}
}
\value{
A list containing the parsed JSON response from the API, where each
element in the list represents an available reporting period. If
\code{as_data_frame = TRUE}, then the list is converted to a tibble (and
returned as such).
}
\description{
Retrieves Call Report or UBPR filer information from the FFIEC
Central Data Repository API for available reporating periods.
}
\examples{
if (!no_creds_available()) {
  # Assume you have set the following environment variables:
  # - FFIEC_USER_ID
  # - FFIEC_BEARER_TOKEN

  # Retrieve reporting periods and return as a list
  get_reporting_periods()

  # Retrieve UBPR reporting periods and return as a tibble
  get_ubpr_reporting_periods(as_data_frame = TRUE)
}
}
\references{
\url{https://cdr.ffiec.gov/public/Files/SIS611_-_Retrieve_Public_Data_via_Web_Service.pdf}
}
