% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore-space-pca.R
\name{flip_sign}
\alias{flip_sign}
\alias{compute_pca}
\title{Helper functions for `explore_space_pca()`}
\usage{
flip_sign(dt, group = NULL, ...)

compute_pca(dt, group = NULL, random = TRUE, flip = TRUE, ...)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in \code{tourr}}

\item{group}{the variable to label different runs of the optimiser(s)}

\item{...}{other arguments received from \code{explore_space_pca()}}

\item{random}{logical; if random bases from the basis space need to be added to the data}

\item{flip}{logical; if the sign flipping need to be performed}
}
\value{
\code{flip_sign()}: a list containing a matrix of all the bases, a logical
 value indicating whether a flip of sign is performed, and a data frame of
  the original dataset.

\code{compute_pca()}: a list containing the PCA summary and a data frame
  with PC coordinates augmented.
}
\description{
Helper functions for `explore_space_pca()`
}
\examples{
dt <- dplyr::bind_rows(holes_1d_geo, holes_1d_better)
 flip_sign(dt, group = method) \%>\% str(max = 1)
compute_pca(dt, group = method)
}
