% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huber-plot.R
\docType{data}
\name{StatHuber}
\alias{StatHuber}
\alias{stat_huber}
\alias{geom_huber}
\alias{GeomHuber}
\alias{prep_huber_best_proj}
\alias{theme_huber}
\title{Create Huber plots with ggplot2}
\format{
An object of class \code{StatHuber} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.

An object of class \code{GeomHuber} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 4.
}
\usage{
StatHuber

stat_huber(
  mapping = NULL,
  data = NULL,
  geom = "path",
  position = "identity",
  ...,
  index.fun,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_huber(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  index.fun,
  ref.circle.color = NULL,
  ref.circle.colour = NULL,
  ref.circle.linetype = "dashed",
  ref.circle.linewidth = NULL,
  idx.max.color = NULL,
  idx.max.colour = NULL,
  idx.max.linetype = "dashed",
  idx.max.linewidth = NULL,
  idx.profile.color = NULL,
  idx.profile.colour = NULL,
  idx.profile.linetype = "solid",
  idx.profile.linewidth = NULL,
  proj.points.color = NULL,
  proj.points.colour = NULL,
  proj.points.stroke = NULL,
  proj.points.alpha = NULL,
  proj.points.size = NULL,
  proj.points.shape = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

GeomHuber

prep_huber_best_proj(data, index_fun)

theme_huber(...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use to display the data for this layer.
When using a \verb{stat_*()} function to construct a layer, the \code{geom} argument
can be used to override the default coupling between stats and geoms. The
\code{geom} argument accepts the following:
\itemize{
\item A \code{Geom} ggproto subclass, for example \code{GeomPoint}.
\item A string naming the geom. To give the geom as a string, strip the
function name of the \code{geom_} prefix. For example, to use \code{geom_point()},
give the geom as \code{"point"}.
\item For more information and other ways to specify the geom, see the
\link[ggplot2:layer_geoms]{layer geom} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{index.fun, index_fun}{the projection pursuit index function, see examples}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:annotation_borders]{annotation_borders()}}.}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used to override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{ref.circle.color, ref.circle.colour, ref.circle.linetype, ref.circle.linewidth}{Default aesthetics for the reference circle}

\item{idx.max.color, idx.max.colour, idx.max.linetype, idx.max.linewidth}{Default aesthetics for the line indicating the best projection direction}

\item{idx.profile.color, idx.profile.colour, idx.profile.linetype, idx.profile.linewidth}{Default aesthetics for the index profile line}

\item{proj.points.color, proj.points.colour, proj.points.stroke, proj.points.alpha, proj.points.size, proj.points.shape}{Default aesthetics for the projected data points}
}
\description{
The Huber plot presents the projection pursuit index values of 2D data in each 1D
projection in polar coordinates, corresponding to each projection direction.
It offers a simpler illustration of more complex projection from
high-dimensional data to lower dimensions in projection pursuit. The
function \code{prep_huber()} calculates each component required for the Huber plot
(see details), which can then be supplied to various geom layers in ggplot2.
}
\details{
the \code{prep_huber()} function calculates components required for
making the Huber plots. It returns a list including three elements:
\describe{
     \item{the \code{idx_df} data frame: }{the x/y coordinates of the index value, in polar
coordinates. Used for plotting the index value at each projection direction,
with the reference circle.}
     \item{the \code{proj_df} data frame: }{the best 1D projection. Used for plotting
the 1D projection in histogram.}
     \item{the \code{slope} value: }{the slope to plot in the Huber plot to indicate the
direction of the best 1D projection.}
   }
}
\examples{
library(ggplot2)
library(tourr)
library(ash)
data(randu)
# simplify the randu data into 2D for illustration
randu_std <- as.data.frame(apply(randu, 2, function(x) (x-mean(x))/sd(x)))
randu_std$yz <- sqrt(35)/6*randu_std$y-randu_std$z/6
randu_df <- randu_std[c(1,4)]

# main example: Huber plot with geom_huber()
randu_df |>
  ggplot()  +
  geom_huber(aes(x = x, y = yz), index.fun = norm_bin(nr = nrow(randu_df))) +
  coord_fixed() +
  theme_huber()

# compute the best projection data for histogram
randu_huber_best <- prep_huber_best_proj(
  randu_df, index_fun = norm_bin(nr = nrow(randu_df))
  )
randu_huber_best |>
  ggplot() +
  geom_histogram(aes(x = x), breaks = seq(-2.2, 2.4, 0.12)) +
  xlab("") + ylab("") +
  theme_bw() +
  theme(axis.text.y = element_blank())
}
\keyword{datasets}
