% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explore-space-pca.R
\name{explore_space_start}
\alias{explore_space_start}
\alias{explore_space_end}
\alias{explore_space_pca}
\title{Plot the PCA projection of the projection bases space}
\usage{
explore_space_start(dt, group = NULL, pca = TRUE, ...)

explore_space_end(dt, group = NULL, pca = TRUE, ...)

explore_space_pca(
  dt,
  details = FALSE,
  pca = TRUE,
  group = NULL,
  color = NULL,
  facet = NULL,
  ...,
  animate = FALSE
)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in \code{tourr}}

\item{group}{the variable to label different runs of the optimiser(s)}

\item{pca}{logical; if PCA coordinates need to be computed for the data}

\item{...}{other arguments passed to \code{add_*()} functions}

\item{details}{logical; if components other than start, end and interpolation need to be shown}

\item{color}{the variable to be coloured by}

\item{facet}{the variable to be faceted by}

\item{animate}{logical; if the interpolation path needs to be animated}
}
\value{
a ggplot2 object
}
\description{
Plot the PCA projection of the projection bases space
}
\examples{
dplyr::bind_rows(holes_1d_geo, holes_1d_better) \%>\%
  bind_theoretical(matrix(c(0, 1, 0, 0, 0), nrow = 5),
    index = tourr::holes(), raw_data = boa5
  ) \%>\%
  explore_space_pca(group = method, details = TRUE) +
  scale_color_discrete_botanical()

\dontrun{
best <- matrix(c(0, 1, 0, 0, 0), nrow = 5)
dt <- bind_theoretical(holes_1d_jellyfish, best, tourr::holes(), raw_data = boa5)
explore_space_start(dt)
explore_space_end(dt, group = loop, theo_size = 10, theo_color = "#FF0000")
explore_space_pca(
  dt, facet = loop, interp_size = 0.5, theo_size = 10,
  start_size = 1, end_size = 3
  )
}
}
\seealso{
Other main plot functions: 
\code{\link{explore_space_tour}()},
\code{\link{explore_trace_interp}()},
\code{\link{explore_trace_search}()}
}
\concept{main plot functions}
