% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_types.r
\name{are-scalar-type-predicates}
\alias{are-scalar-type-predicates}
\alias{are_scalar_list}
\alias{are_scalar_atomic}
\alias{are_scalar_vector}
\alias{are_scalar_integer}
\alias{are_scalar_double}
\alias{are_scalar_complex}
\alias{are_scalar_character}
\alias{are_string}
\alias{are_scalar_logical}
\alias{are_bool}
\alias{are_scalar_raw}
\alias{are_scalar_bytes}
\title{Scalar type predicates}
\usage{
are_scalar_list(..., .all = FALSE)

are_scalar_atomic(..., .all = FALSE)

are_scalar_vector(..., .all = FALSE)

are_scalar_integer(..., .all = FALSE)

are_scalar_double(..., .all = FALSE)

are_scalar_complex(..., .all = FALSE)

are_scalar_character(..., .all = FALSE)

are_string(..., .string = NULL, .all = FALSE)

are_scalar_logical(..., .all = FALSE)

are_bool(..., .all = FALSE)

are_scalar_raw(..., .all = FALSE)

are_scalar_bytes(..., .all = FALSE)
}
\arguments{
\item{...}{Objects to be tested.}

\item{.all}{Whether to return if all arguments are TRUE.}

\item{.string}{A string/character vector to compare to the inputs.}
}
\value{
Named logical, or unnamed boolean if \code{.all} is \code{TRUE}.
}
\description{
Wrappers around \link[rlang:rlang-package]{rlang} scalar type predicates that
allow multiple objects to be passed. The following documentation is adapted
from the rlang \link[rlang:scalar-type-predicates]{documentation}:

These predicates check for a given type and whether the vector is
"scalar", that is, of length 1.

In addition to the length check, \code{are_string()} and \code{are_bool()}
return \code{FALSE} if their input is missing. This is useful for
type-checking arguments, when your function expects a single string
or a single \code{TRUE} or \code{FALSE}.
}
\details{
The optional input of \code{.string} can be given character vectors
that map to the arguments in \code{...}. If unnamed vector/list, the input must
either be the same length as the number of arguments given to \code{...}, or
length 1: which is then recycled to the number number of arguments
given to \code{...}. Alternatively, a named vector/list can be given, where
the values for matching named elements are passed to the type predicate,
but unmatched names are passed NULL. List inputs can pass different
character vectors for each dot argument. When a character vector is given for
a single argument, \code{TRUE} is returned if at least one element is equal.
}
\examples{
x <- 1
y <- list()
z <- mean

are_scalar_list(x, y, z, list(1))

# `.all` can be given to test if all inputs
# evaluate to TRUE
are_list(x, y, z, list(1), .all = TRUE)
}
\seealso{
\link{are-type-predicates}, \link{are-bare-type-predicates}
}
