% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_faunabr.R
\name{filter_faunabr}
\alias{filter_faunabr}
\title{Identify records outside natural ranges according to Fauna do Brasil}
\usage{
filter_faunabr(data, occ, species = "species", long = "x", lat = "y",
                      by_state = TRUE, buffer_state = 20, by_country = TRUE,
                      buffer_country = 20, value = "flag&clean",
                      keep_columns = TRUE, spat_state = NULL,
                      spat_country = NULL, verbose = TRUE)
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_faunabr}} function.}

\item{occ}{(data.frame) a data.frame with the records of the species.}

\item{species}{(character) column name in occ with species names.
Default = "species"}

\item{long}{(character) column name in occ with longitude data. Default = "x"}

\item{lat}{(character) column name in occ with latitude data. Default = "y"}

\item{by_state}{(logical) filter records by state? Default = TRUE}

\item{buffer_state}{(numeric) buffer (in km) around the polygons of the
states of occurrence of the specie. Default = 20.}

\item{by_country}{(logical) filter records by country? Default = TRUE}

\item{buffer_country}{(numeric) buffer (in km) around the polygons of the
countries of occurrence of the specie. Default = 20.}

\item{value}{(character) Defines output values. See Value section.
Default = "flag&clean".}

\item{keep_columns}{(logical) if TRUE, keep all the original columns of the
input occ. If False, keep only the columns species, long and lat.
Default = TRUE}

\item{spat_state}{(SpatVector) a SpatVector of the Brazilian states. By
default, it uses the SpatVector provided by geobr::read_state(). It can be
another Spatvector, but the structure must be identical to
'faunabr::states', with a column called "abbrev_state" identifying the states
codes.}

\item{spat_country}{(SpatVector) a SpatVector of the world countries. By
default, it uses the SpatVector provided by rnaturalearth::ne_countries. It
can be another Spatvector, but the structure must be identical to
'faunabr::world_fauna', with a column called "country_code" identifying the
country codes.}

\item{verbose}{(logical) Whether to display species being filtered during
function execution. Set to TRUE to enable display, or FALSE to run silently.
Default = TRUE.}
}
\value{
Depending on the 'value' argument. If value = "flag", it returns the
same data.frame provided in data with additional columns indicating if the
record falls inside the natural range of the specie (TRUE) or outside
(FALSE).
If value = "clean", it returns a data.frame with only the records that passes
all the tests (TRUE for all the filters). If value = "flag&clean" (Default),
it returns a list with two data.frames: one with the flagged records and one
with the cleaned records.
}
\description{
This function removes or flags records outside of the species'
natural ranges according to information provided by the Fauna do Brasil database
}
\details{
If by_state = TRUE and/or by_country = TRUE, the function takes polygons
representing the states and/or countrys with confirmed occurrences of the
specie, draws a buffer around the polygons, and tests if the records of the
species fall inside it.
}
\examples{
data("fauna_data") #Load fauna e Funga do Brasil data
data("occurrences") #Load occurrences
pts <- subset(occurrences, species == "Panthera onca")
fd <- filter_faunabr(data = fauna_data,
                     occ = pts, long = "x", lat = "y", species = "species",
                     by_state = TRUE, buffer_state = 20,
                     by_country = TRUE, buffer_country = 20,
                     value = "flag&clean", keep_columns = TRUE,
                     verbose = FALSE)
}
