% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fauna_synonym.R
\name{fauna_synonym}
\alias{fauna_synonym}
\title{Retrieve synonyms for species}
\usage{
fauna_synonym(data, species,
                   include_subspecies = TRUE)
}
\arguments{
\item{data}{(data.frame) the data.frame imported with the
\code{\link{load_faunabr}} function}

\item{species}{(character) names of the species}

\item{include_subspecies}{(logical) include subspecies that are synonyms of
the species? Default = TRUE}
}
\value{
A data.frame containing unique synonyms of the specified species
along with relevant information on taxonomic status.
}
\description{
Retrieve synonyms for species
}
\examples{
data("fauna_data") #Load Flora e Funga do Brasil data
#Species to extract synonyms
spp <- c("Panthera onca", "Mazama jucunda", "Subulo gouzoubira")
spp_synonyms <- fauna_synonym(data = fauna_data, species = spp,
                              include_subspecies = FALSE)
spp_synonyms

}
