% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.R
\name{describe}
\alias{describe}
\title{describe}
\usage{
describe(obj, na_rm = TRUE)
}
\arguments{
\item{obj}{Object used to create the table.
\code{data.frame}, \code{list} or environment
(or object coercible by \code{as.data.frame} to a \code{data.frame})}

\item{na_rm}{option to remove \code{NA} from variables}
}
\value{
A tibble with n rows where n is equal to \code{ncol(obj)} and  columns
with
the summary metrics
}
\description{
In the base R we have the function summary, but the output is no by default
a \code{data.frame}, so \code{describe} is an enhancement of this function
to summarize data frames.
}
\examples{
mtcars |>
  fastrep::describe()

airquality |> fastrep::describe(na_rm = FALSE)

iris |> fastrep::describe()

}
