% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_problems.R
\name{qc_fails}
\alias{qc_fails}
\alias{qc_warns}
\alias{qc_problems}
\title{Inspect Problems in Aggregated FastQC Reports}
\usage{
qc_fails(object, element = c("sample", "module"), compact = TRUE)

qc_warns(object, element = c("sample", "module"), compact = TRUE)

qc_problems(
  object,
  element = c("sample", "module"),
  name = NULL,
  status = c("FAIL", "WARN"),
  compact = TRUE
)
}
\arguments{
\item{object}{an object of class qc_aggregate.}

\item{element}{character vector specifying which element to check for 
inspecting problems. Allowed values are one of c("sample", "module"). 
Default is "sample". \itemize{ \item If "sample", shows samples with more 
failed and/or warned modules \item If "module", shows moduled that failed 
and/or warned in the most samples }}

\item{compact}{logical value. If TRUE, returns a compact output format; 
otherwise, returns a stretched format.}

\item{name}{character vector containing the names of modules and/or samples of
interest. See \link{qc_read} for valid module names. If name specified, a 
stretched output format is returned by default unless you explicitly indicate
compact = TRUE.}

\item{status}{character vector specifying the module status. Allowed values 
includes one or the combination of c("FAIL", "WARN"). If status = "FAIL", 
only modules with failed status are returned.}
}
\value{
\itemize{
   \item \strong{qc_problems(), qc_fails(), qc_warns()}: returns a tibble (data frame) containing samples
   that had one or more modules with failure or warning.
   The format and the interpretation of the results depend on the argument 'element',
   which value is one of c("sample", "module").
    \itemize{
    \item \strong{If element = "sample" (default)}, results are samples with failed and/or warned modules. 
    The results contain the following columns: sample (sample names),
    nb_problems (the number of modules with problems), module (the name of modules with problems).
    \item \strong{If element = "module"}, results are modules that failed and/or warned in the most samples. 
    The results contain the following columns:
    module (the name of module with problems), nb_problems (the number of samples with problems),
    sample (the name of samples with problems)
    }
    
  }
}
\description{
Inspect problems in aggregated FastQC reports.
}
\section{Functions}{
\itemize{
\item \code{qc_fails()}: Displays which samples had one or more failed modules. Use
qc_fails(qc, "module") to see which modules failed in the most samples.

\item \code{qc_warns()}: Displays which samples had one or more warned modules. Use
qc_warns(qc, "module") to see which modules warned in the most samples.

\item \code{qc_problems()}: Union of \code{qc_fails()} and \code{qc_warns()}. 
Display which samples or modules that failed or warned.

}}
\examples{
# Demo QC dir
qc.dir <- system.file("fastqc_results", package = "fastqcr")
qc.dir
# List of files in the directory
list.files(qc.dir)

# Aggregate the report
qc <- qc_aggregate(qc.dir, progressbar = FALSE)

# Display samples with failed modules
qc_fails(qc)
qc_fails(qc, compact = FALSE)

# Display samples with warned modules
qc_warns(qc)

# Module failed in the most samples
qc_fails(qc, "module")
qc_fails(qc, "module", compact = FALSE)

# Specify a module of interest
qc_problems(qc, "module",  name = "Per sequence GC content")

}
