% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.distance.mpl.R
\name{metric.distance.mpl}
\alias{metric.distance.mpl}
\title{Median Path Length}
\usage{
metric.distance.mpl(
  Network,
  probability = 0.95,
  error = 0.03,
  Cores = detectCores(),
  full = FALSE
)
}
\arguments{
\item{Network}{The input network.}

\item{probability}{The confidence level probability}

\item{error}{The sampling error}

\item{Cores}{Number of cores to use in the computations. By default \code{detecCores()} from \emph{parallel}.}

\item{full}{It calculates the sampling version by default. If it is set to true, the population MPL will be calculated and the rest of the parameters will be ignored.}
}
\value{
A real integer
}
\description{
Calculate the median path length (MPL) of a network.
}
\details{
The median path length (MPL) is the median shortest path lengths of all pairs of nodes in \emph{Network}.
\emph{metric.distance.mpl(g)} calculates the population MPL OR estimated MPL of network g with a sampling error set by the user. The calculation uses a parallel load balancing approach, distributing jobs equally among the cores defined by the user.
}
\examples{
\dontrun{
##Default function
x <-  net.erdos.renyi.gnp(1000,0.01)
metric.distance.mpl(x)
##Population MPL
metric.distance.mpl(x, full=TRUE)
##Sampling at 99\% level with an error of 10\% using 5 cores
metric.distance.mpl(Network = x, probability=0.99, error=0.1, Cores=5)
}

}
\references{
E. W. Dijkstra. 1959. A note on two problems in connexion with graphs. Numer. Math. 1, 1 (December 1959), 269-271.

Castro L, Shaikh N. Estimation of Average Path Lengths of Social Networks via Random Node Pair Sampling. Department of Industrial Engineering, University of Miami. 2016.
}
\author{
Luis Castro, Nazrul Shaikh.
}
