% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mi_test.R
\name{mi.test}
\alias{mi.test}
\title{Mutual Information Test}
\usage{
mi.test(x, y, k = 5, distance = FALSE, num.permutations = 99,
  seed = 1)
}
\arguments{
\item{x}{A numeric vector, matrix, data.frame or \code{\link{dist}} object.}

\item{y}{A numeric vector, matrix, data.frame or \code{\link{dist}} object.}

\item{k}{Order of neighborhood to be used in the kNN method.}

\item{distance}{Bool flag for considering \code{x} and \code{y} as distance matrices or not.
If \code{distance = TRUE}, \code{x} and \code{y} would be considered as distance matrices,
otherwise, these arguments are treated as data and
Euclidean distance would be implemented for the samples in \code{x} and \code{y}.
Default: \code{distance = FALSE}.}

\item{num.permutations}{The number of permutation replications.
If \code{num.permutations = 0}, the function just returns the Mutual Information statistic.
Default: \code{num.permutations = 99}.}

\item{seed}{The random seed. Default: \code{seed = 1}.}
}
\value{
If \code{num.permutations > 0}, \code{mi.test} returns a \code{htest}
class object containing the following components:
\item{\code{statistic}}{Mutual Information statistic.}
\item{\code{p.value}}{The p-value for the test.}
\item{\code{replicates}}{Permutation replications of the test statistic.}
\item{\code{size}}{Sample size.}
\item{\code{alternative}}{A character string describes the alternative hypothesis.}
\item{\code{method}}{A character string indicates what type of test was performed.}
\item{\code{data.name}}{Description of data.}
If \code{num.permutations = 0}, \code{mi.test} returns a statistic value.
}
\description{
Mutual Information test of independence.
Mutual Information are generic dependence measures in Banach spaces.
}
\details{
If two samples are passed to arguments \code{x} and \code{y}, the sample sizes
(i.e. number of rows of the matrix or length of the vector) must agree.
Moreover, data being passed to \code{x} and \code{y} must not contain missing or infinite values.

\code{mi.test} utilizes the Mutual Information statistics (see \code{\link{mi}})
to measure dependence and derive a \eqn{p}-value via replicating the random permutation \code{num.permutations} times.
}
\examples{
library(fastmit)
set.seed(1)
error <- runif(50, min = -0.3, max = 0.3)
x <- runif(50, 0, 4*pi)
y <- cos(x) + error
# plot(x, y)
res <- mi.test(x, y)
}
