% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-liureg.R
\name{print.liureg}
\alias{print.liureg}
\title{Print method for liureg objects}
\usage{
\method{print}{liureg}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{x}{An object of class \code{liureg}.}

\item{digits}{Number of decimal places in the coefficients data.frame.}

\item{...}{Not used in this implementation.}
}
\value{
The returned object is a data.frame showing the coefficients path.
}
\description{
Prints coefficients paths for Liu regression models over a grid of values for
the regularization (biasing) parameter lambda.
}
\examples{
Hitters <- na.omit(Hitters)
X <- model.matrix(Salary ~ ., Hitters)[, -1]
y <- Hitters$Salary
lam <- seq(0, 1, 0.01)
liu.mod <- liureg(X, y, lam)
print(liu.mod)
}
\seealso{
\code{\link[=liureg]{liureg()}}, \code{\link[=summary]{summary()}}, \code{\link[=pressliu]{pressliu()}}, \code{\link[=residuals]{residuals()}}
}
\author{
Murat Genç
}
