% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covliureg.R
\name{covliu}
\alias{covliu}
\title{Covariance matrix based on a fitted liureg object.}
\usage{
covliu(obj)
}
\arguments{
\item{obj}{A \code{liureg} object.}
}
\value{
The returned object is a list of the matrix of estimated covariances.
}
\description{
For a scalar or vector tuning parameter lambda,
the \code{covliureg} computes the covariance matrix
for the estimates of a Liu regression model.
}
\examples{
data("Hitters")
Hitters <- na.omit(Hitters)
X <- model.matrix(Salary ~ ., Hitters)[, -1]
y <- Hitters$Salary
lam <- seq(0, 1, 0.01)
liu.mod <- liureg(X, y, lam)
# List of covariance matrices for 101 lambda values
cov.mat <- covliu(liu.mod)
print(cov.mat$lam1)
}
\seealso{
\code{\link[=liureg]{liureg()}}, \code{\link[=coef]{coef()}}, \code{\link[=predict]{predict()}}, \code{\link[=summary]{summary()}}, \code{\link[=pressliu]{pressliu()}}, \code{\link[=residuals]{residuals()}}
}
\author{
Murat Genç and Ömer Özbilen
}
