% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian_snapshot_ss.R
\name{gaussian_snapshot_ss}
\alias{gaussian_snapshot_ss}
\title{Simulate Gaussian edge networks with nonparametric latent processes}
\usage{
gaussian_snapshot_ss(n,d,m,x_vec,self_loops=TRUE,
                     sigma_edge=1,process_options)
}
\arguments{
\item{n}{A positive integer, the number of nodes.}

\item{d}{A positive integer, the number of latent space dimensions.}

\item{m}{A positive integer, the number of snapshots.
If this argument is not specified, it
is determined from the snapshot index vector \code{x_vec}.}

\item{x_vec}{A vector, the snapshot evaluation indices for the data.
Defaults to an equally spaced sequence of length
\code{m} from \code{0} to \code{1}.}

\item{self_loops}{A Boolean, if \code{FALSE}, all diagonal adjacency matrix
entries are set to zero. Defaults to \code{TRUE}.}

\item{sigma_edge}{A positive scalar,
the entry-wise standard deviation for the Gaussian edge variables.
Defaults to \code{1}.}

\item{process_options}{A list, containing additional optional arguments:
\describe{
\item{amplitude}{A positive scalar, the maximum amplitude of the
randomly generated latent processes. Defaults to \code{3}.}
\item{frequency}{A positive scalar, frequency of the randomly
generated latent processes. Defaults to \code{2}.}
\item{sigma_int}{A positive scalar, or a vector of length \eqn{d}.
If it is a vector, the entries correspond to the standard deviation
of the random intercepts of the node processes for each latent dimension.
If is is a scalar, it corresponds to the standard deviation of the
random intercepts in all dimensions. Defaults to \code{0.5}.}
\item{return_fn}{A Boolean, if \code{TRUE}, then the latent processes
are returned as a function which
takes a vector of indices and returns the corresponding evaluations of
the latent process matrices. Otherwise, the latent processes are returned
as an \eqn{n \times d \times m} array evaluated at the prespecified
snapshot indices. Defaults to \code{FALSE}.}
}}
}
\value{
A list is returned with the realizations of the basis coordinates,
spline design, and the multiplex network snapshots:
\item{A}{An array of dimension \eqn{n \times n \times m}, the realized
functional network data.}
\item{Z}{If \code{process_options$return_fn} is \code{TRUE}, a function,
which takes a vector of indices and returns the corresponding evaluations of
the latent process matrices. Otherwise, an array of dimension \eqn{n \times d \times m},
the latent processes evaluated at the prespecified
snapshot indices.}
\item{spline_design}{A list, describing the \eqn{B}-spline design:
\describe{
\item{type}{The string \code{'ss'}.}
\item{x_vec}{A vector, the snapshot evaluation indices for the data.}
}}
}
\description{
\code{gaussian_snapshot_ss} simulates a realization of a functional network
with Gaussian edges, according to an inner product latent process model.
The latent processes are randomly generated sinusoidal functions.
}
\details{
The the latent process for node \eqn{i} in latent dimension \eqn{r} is given independently by
\deqn{z_{i,r}(x) = \frac{a \sin [2f\pi(x - U) / (x_{max} - x_{min})]}{1 + (2a-1)[x + B(x_{max} - 2x)]} + G}
Where \eqn{G} is Gaussian with mean \code{0} and standard deviation
\eqn{\sigma_{int,r}}, \eqn{B} is Bernoulli with mean \code{1/2}, and \eqn{U} is uniform
with minimum \code{spline_design$x_min} and maximum \code{spline_design$x_max}.
\eqn{f} is a frequency parameter specified with
\code{process_options$frequency}, and \eqn{a} is a maximum amplitude parameter
specified with \code{process_options$amplitude}.
Roughly, each process is a randomly shifted sine function which goes through
\code{f} cycles on the index set, with amplitude either increasing or
decreasing between \eqn{1/2} and \eqn{a}.

Then, the \eqn{n \times n} symmetric adjacency matrix for
snapshot \eqn{k=1,...,m} has independent Gaussian entries
with standard deviation \code{sigma_edge} and mean
\deqn{E([A_k]_{ij}) = z_i(x_k)^{T}z_j(x_k)}
for \eqn{i \leq j} (or \eqn{i < j} with no self loops).

This function may return the latent processes as an \eqn{n \times d \times m}
array evaluated at the prespecified snapshot indices, or as a function which
takes a vector of indices and returns the corresponding evaluations of
the latent process matrices.
It also returns the spline design information required to
fit a FASE embedding to this data with a natural cubic spline.
}
\examples{

# Gaussian edge data with sinusoidal latent processes
# NOTE: latent processes are returned as a function

data <- gaussian_snapshot_ss(n=100,d=2,
                             x_vec=seq(0,3,length.out=80),
                             self_loops=TRUE,
                             sigma_edge=4,
                             process_options=list(amplitude=4,
                                                  frequency=3,
                                                  return_fn=TRUE))

}
