#' DROPS data sets
#'
#' These datasets come from the European Union project DROPS (DROught-tolerant
#' yielding PlantS). A panel of 256 maize hybrids was grown with two water
#' regimes (irrigated or rainfed), in seven fields in 2012 and 2013,
#' respectively, spread along a climatic transect from western to eastern
#' Europe, plus one site in Chile in 2013. This resulted in 28 experiments
#' defined as the combination of one year, one site and one water regime, with
#' two and three repetitions for rainfed and irrigated treatments, respectively.
#' A detailed environmental characterisation was carried out, with hourly
#' records of micrometeorological data and soil water status, and associated
#' with precise measurement of phenology. Grain yield and its components were
#' measured at the end of the experiment.\cr
#' The data sets contain the genotypic BLUEs for eight traits for 246 genotypes
#' in 37 environments. Additionally information on 11 environmental indices
#' is included. The environments are split in three data sets for training
#' (\code{drops_GE}) and testing (\code{drops_GnE}, \code{drops_nGnE})
#' purposes. \code{drops_K} contains the kinship matrix for the 246 genotypes.
#'
#' @format data.frames with 24 variables.
#' \describe{
#' \item{Experiment}{experiments ID described by the three first letters of the
#' city’s name followed by the year of experiment and the water regime with W
#' for watered and R for rain-fed.}
#' \item{Code_ID, Variety_ID, Accession_ID}{identifier of the genotype}
#' \item{grain.yield}{genotypic mean for yield adjusted at 15\% grain moisture,
#' in ton per hectare (t ha^-1)}
#' \item{grain.number}{genotypic mean for number of grain per square meter}
#' \item{grain.weight}{genotypic mean for individual grain weight in milligram
#'  (mg)}
#' \item{anthesis}{genotypic mean for male flowering (pollen shed), in thermal
#' time cumulated since emergence (d_20°C)}
#' \item{silking}{genotypic mean for female flowering (silking emergence), in
#' thermal time cumulated since emergence (d_20°C)}
#' \item{plant.height}{genotypic mean for plant height, from ground level to
#' the base of the flag leaf (highest) leaf in centimeter (cm)}
#' \item{tassel.height}{genotypic mean for plant height including tassel, from
#' ground level to the highest point of the tassel in centimeter (cm)}
#' \item{ear.height}{genotypic mean for ear insertion height, from ground level
#' to ligule of the highest ear leaf in centimeter (cm)}
#' \item{\code{Tnight.Early}}{night temperature averaged between the floral
#' transition and the silk initiation}
#' \item{\code{Tnight.Flo}}{night temperature averaged between the silk
#' initiation and the end of grain abortion}
#' \item{\code{Tnight.Fill}}{night temperature averaged between the end of
#' grain abortion and the physiological maturity of the grain}
#' \item{\code{Ri.Early}}{intercepted radiation cumulated between the floral
#' transition and the silk initiation}
#' \item{\code{Ri.Flo}}{intercepted radiation cumulated between the silk
#' initiation and the end of grain abortion}
#' \item{\code{Ri.Fill}}{intercepted radiation cumulated between the end of
#' grain abortion and the physiological maturity of the grain}
#' \item{\code{Psi.Flo}}{soil water potential averaged between the silk
#' initiation and the end of grain abortion. The soil water potential used
#' here was the median between 30 and 60cm depth.}
#' \item{\code{Psi.Fill}}{soil water potential averaged between the end of
#' grain abortion and the physiological maturity of the grain}
#' \item{\code{Tmax.Early}}{maximum temperature averaged between the floral
#'  transition and the silk initiation}
#' \item{\code{Tmax.Flo}}{maximum temperature averaged between the silk
#' initiation and the end of grain abortion}
#' \item{\code{Tmax.Fill}}{maximum temperature averaged between the end
#' of grain abortion and the physiological maturity of the grain}
#' \item{\code{type}}{code corresponding to the data set. GE for drops_GE,
#' GnE for drops_GnE and nGnE for drops_nGnE.}
#'}
#'
#' @source \doi{10.15454/IASSTN}
#'
#' @references Millet, E. J., Pommier, C., et al. (2019). A multi-site
#' experiment in a network of European fields for assessing the maize yield
#' response to environmental scenarios (Data set).
#' \doi{10.15454/IASSTN}
#'
"drops_GE"

#' @rdname drops_GE
"drops_GnE"

#' @rdname drops_GE
"drops_nGnE"

#' @rdname drops_GE
"drops_K"
