% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tsfm.R
\name{plot.tsfm}
\alias{plot.tsfm}
\title{Plots from a fitted time series factor model}
\usage{
\method{plot}{tsfm}(
  x,
  which = NULL,
  f.sub = 1:2,
  a.sub = 1:6,
  plot.single = FALSE,
  asset.name,
  colorset = c("royalblue", "dimgray", "olivedrab", "firebrick", "goldenrod",
    "mediumorchid", "deepskyblue", "chocolate", "darkslategray"),
  legend.loc = "topleft",
  las = 1,
  lwd = 2,
  maxlag = 15,
  ...
)
}
\arguments{
\item{x}{an object of class \code{tsfm} produced by \code{fitTsfm}.}

\item{which}{a number to indicate the type of plot. If a subset of the plots 
is required, specify a subset of the numbers 1:12 for group plots and 1:19 
for individual plots. If \code{which=NULL} (default), the following menu 
appears: \cr \cr
For plots of a group of assets: \cr
1 = Factor model coefficients: Alpha, \cr
2 = Factor model coefficients: Betas, \cr
3 = Actual and fitted, \cr
4 = R-squared, \cr
5 = Residual volatility,\cr
6 = Scatterplot matrix of residuals, with histograms, density overlays, correlations and significance stars, \cr
7 = Factor model residual correlation \cr
8 = Factor model return correlation,\cr
9 = Factor contribution to SD,\cr
10 = Factor contribution to ES,\cr
11 = Factor contribution to VaR, \cr
12 = Asset returns vs factor returns (single factor model) \cr \cr
For individual asset plots:\cr
1 = Actual and fitted,\cr
2 = Actual vs fitted,\cr
3 = Residuals vs fitted, \cr
4 = Sqrt. of modified residuals vs fitted, \cr
5 = Residuals with standard error bands, \cr
6 = Time series of squared residuals, \cr
7 = Time series of absolute residuals,\cr
8 = SACF and PACF of residuals,\cr
9 = SACF and PACF of squared residuals,\cr
10 = SACF and PACF of absolute residuals,\cr
11 = Non-parametric density of residuals with normal overlaid, \cr
12 = Non-parametric density of residuals with skew-t overlaid, \cr 
13 = Histogram of residuals with non-parametric density and normal overlaid,\cr
14 = QQ-plot of residuals,\cr
15 = CUSUM test-Recursive residuals, requires strucchange package,\cr
16 = CUSUM test-LS residuals, requires strucchange package,\cr
17 = Recursive estimates (RE) test of LS regression coefficients, requires strucchange package,\cr
18 = Rolling regression over a 24-period observation window, \cr
19 = Asset returns vs factor returns (single factor model)}

\item{f.sub}{numeric/character vector; subset of indexes/names of factors to 
include for group plots. Default is 1:2.}

\item{a.sub}{numeric/character vector; subset of indexes/names of assets to 
include for group plots. At least 2 assets must be selected. Default is 1:6.}

\item{plot.single}{logical; If \code{TRUE} plots the characteristics of an 
individual asset's factor model. The type of plot is given by 
\code{which}. Default is \code{FALSE}.}

\item{asset.name}{name of the individual asset to be plotted. Is necessary 
if \code{x} contains multiple asset fits and \code{plot.single=TRUE}.}

\item{colorset}{color palette to use for all the plots. The 1st element will 
be used for individual time series plots or the 1st object plotted, the 2nd 
element for the 2nd object in the plot and so on.}

\item{legend.loc}{places a legend into one of nine locations on the chart: 
"bottomright", "bottom", "bottomleft", "left", "topleft", "top", "topright", 
"right", or "center". Default is "bottomright". Use \code{legend.loc=NULL} 
to suppress the legend.}

\item{las}{one of \code{0, 1, 2, 3} to set the direction of axis labels, same as 
in \code{plot}. Default is 1.}

\item{lwd}{set the line width, same as in \code{\link{plot}}. Default is 2.}

\item{maxlag}{optional number of lags to be calculated for ACF. Default is 15.}

\item{...}{further arguments to be passed to other plotting functions.}
}
\value{
\code{plot.tsfm} returns a plot for an object of class \code{tsfm}.
}
\description{
Generic \code{plot} method for object of class \code{tsfm}. 
Plots chosen characteristic(s) for one or more assets.
}
\details{
The function can be used for group plots and individual plots. User can 
select the type of plot either from the menu prompt (default) or directly 
via argument \code{which}.

In case multiple plots are needed, the menu is repeated after each plot 
(enter 0 to exit). User can also input a numeric vector of plot options via 
\code{which}.

Group plots are the default. The selected assets in \code{a.sub} and 
selected factors in \code{f.sub} are plotted depending on the 
characteristic chosen. The default is to show the first 2 factors and first 
6 assets.

Setting \code{plot.single=TRUE} enables individual plots. If there is more 
than one asset fit by \code{x}, \code{asset.name} should be specified. 
In case the \code{tsfm} object \code{x} contains only a single asset fit, 
plot.tsfm can infer \code{asset.name} without user input. 

CUSUM plots (individual asset plot options 15, 16 and 17) are applicable 
only for \code{fit.method="LS"}.

Modified residuals, rolling regression and single factor model plots 
(individual asset plot options 4, 18 and 19) are not applicable for 
\code{variable.selection="lars"}.

The last option for plotting asset returns vs. factor returns (individual 
asset plot option 19 and group plot 12) are only applicable for single factor
models.
}
\seealso{
\code{\link{fitTsfm}}, \code{\link{residuals.tsfm}}, 
\code{\link{fitted.tsfm}}, \code{\link{fmCov.tsfm}} and 
\code{\link{summary.tsfm}} for time series factor model fitting and related 
S3 methods. Refer to \code{\link{fmSdDecomp}}, \code{\link{fmEsDecomp}}, 
\code{\link{fmVaRDecomp}} for factor model risk measures.

Here is a list of plotting functions used. (I=individual, G=Group)
I(1,5,6,7), G(3) - \code{\link[PerformanceAnalytics]{chart.TimeSeries}}, 
I(2,3,4,19), G(12) - \code{\link[graphics]{plot.default}},
I(3,4) - \code{\link[graphics]{panel.smooth}},
I(8,9,10) - \code{\link[PerformanceAnalytics]{chart.ACFplus}}, 
I(11,12) - \code{\link[stats]{plot.density}},
I(13) - \code{\link[PerformanceAnalytics]{chart.Histogram}},
I(14) - \code{\link[PerformanceAnalytics]{chart.QQPlot}}, 
I(15,16,17) - \code{\link[strucchange]{plot.efp}} (requires strucchange package),
I(18) - \code{\link[zoo]{plot.zoo}},
G(1,2,4,5,9,10,11) - \code{\link[lattice]{barchart}},
G(6) - \code{\link[PerformanceAnalytics]{chart.Correlation}} and
G(7,8) - \code{\link[corrplot]{corrplot.mixed}} (requires corrplot package).
}
\author{
Eric Zivot, Sangeetha Srinivasan and Yi-An Chen
}
