% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repExposures.R
\name{repExposures}
\alias{repExposures}
\title{Portfolio Exposures Report}
\usage{
repExposures(
  ffmObj,
  weights = NULL,
  isPlot = TRUE,
  isPrint = TRUE,
  scaleType = "free",
  stripText.cex = 1,
  axis.cex = 1,
  stripLeft = TRUE,
  layout = NULL,
  color = "blue",
  notch = FALSE,
  digits = 1,
  titleText = TRUE,
  which = NULL,
  type = "b",
  ...
)
}
\arguments{
\item{ffmObj}{an object of class ffm returned by fitFfm.}

\item{weights}{a vector of weights of the assets in the portfolio. Default is NULL.}

\item{isPlot}{logical variable to generate plot or not.}

\item{isPrint}{logical variable to print numeric summary or not.}

\item{scaleType}{scaleType controls if use a same scale of y-axis, choose from c('same', 'free')}

\item{stripText.cex}{a number indicating the amount by which strip text in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{axis.cex}{a number indicating the amount by which axis in the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% larger, 0.5 is 50\% smaller, etc.}

\item{stripLeft}{logical variable to choose the position of strip, 'TRUE' for drawing strips on the left of each panel, 'FALSE' for drawing strips on the top of each panel. Used only when isPlot = 'TRUE'}

\item{layout}{layout is a numeric vector of length 2 or 3 giving the number of columns, rows, and pages (optional) in a multipanel display. Used only when isPlot = 'TRUE'}

\item{color}{character specifying the plotting color for all the plots}

\item{notch}{logical. if notch is \code{TRUE}, a notch is drawn in each side of the boxes. If the notches of two plots do not overlap this is strong evidence that the two medians differ (Chambers et al, 1983, p. 62).Default values is \code{FALSE}.}

\item{digits}{digits of printout numeric summary. Used only when isPrint = 'TRUE'}

\item{titleText}{logical varible to choose display plot title or not. Default is 'TRUE', and used only when isPlot = 'TRUE'.}

\item{which}{a number to indicate the type of plot. If a subset of the plots 
is required, specify a subset of the numbers 1:3 for plots. If \code{which=NULL} (default), the following menu 
appears: \cr \cr
For plots of a group of assets: \cr
1 = Time series plot of style factor exposures, \cr
2 = Boxplot of style factor exposures, \cr
3 = Barplot of means and vols of style factor exposures, and means of sector exposures (which have no vol). \cr \cr}

\item{type}{character. type of lattice plot when which=1; 'l' denotes a line, 'p' denotes a point, and 'b' and 'o' both denote both together.deafault is 'b'.}

\item{...}{other graphics parameters available in tsPlotMP(time series plot only) can be passed in through the ellipses}
}
\value{
A list containing mean and standard deviation of all the factors
}
\description{
Calculate k factor time series based on fundamental factor model. This method takes fundamental factor model fit, 'ffm' object, and portfolio weight as inputs and generates numeric summary and plot visualization.
}
\author{
Douglas Martin, Lingjie Yi, Avinash
}
