% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codePasses.R
\name{codePasses}
\alias{codePasses}
\title{Codes the Fixations as First Pass and Second Pass}
\usage{
codePasses(
  data,
  AOI,
  rereading = FALSE,
  fpx = NULL,
  fpy = NULL,
  origin = c("topLeft", "bottomLeft", "center", "topRight", "bottomRight"),
  fix_size = 42,
  fix_min = 3
)
}
\arguments{
\item{data}{A data frame containing fixation information of an eye tracing 
experiment. Each row indicates a fixation.}

\item{AOI}{The name or number of the column in \code{data} containing the name
of the area of interest (AOI) that was fixated. If \code{data} contains one 
column per AOI, also a vector is accepted (see Details).}

\item{rereading}{Logical. Indicating if the first pass fixations should be 
split according to forward and rereading (\code{TRUE}) or not 
(\code{FALSE} [Default])}

\item{fpx}{The name or number of the column containing the x coordinate of the 
fixation point. Required if \code{Rereading} is \code{TRUE}.}

\item{fpy}{The name or number of the column containing the y coordinate of the 
fixation point. Required if \code{Rereading} is \code{TRUE}.}

\item{origin}{Character string specifying where the origin of the fixation 
coordinates \code{fpx} and \code{fpy} is located. The following values are
possible: "topLeft" (default), "bottomLeft", "center", "topRight", "bottomRight".}

\item{fix_size}{The size or acuity of the saccade. (default = 42; see Details)}

\item{fix_min}{[optional] minimal number of fixations for first pass. (default = 3; 
see Details)}
}
\value{
The function returns a character vector of the same length as the 
  number of rows in data. Depending on the respective settings it contains 
  the following values with their respective meanings.  
  
  \itemize{
    \item \code{rereading} is \code{FALSE}:
    \itemize{
      \item \code{FP_\#} First Pass
      \item \code{SP_\#} Second Pass
     }
    \item \code{rereading} is \code{TRUE}
    \itemize{
      \item \code{FPF_\#} First Pass Forward
      \item \code{FPR_\#} First Pass Rereading
      \item \code{SP_\#} Second Pass
     }
  }
  
  Where \# stands for the name of the respecitve AOI.
}
\description{
The fixations are coded as first pass and second pass with or without rereading 
  as discussed in Hyönä, Lorch, and Rinck (2003) and Hyönä, and Lorch (2004).
}
\details{
This function takes a data frame containing information of an eye 
  tracking reading exercise Each row indicates a fixation and the columns at 
  least indicate the AOI that was fixated or if a specific AOI was fixated or not. 
  Optionally it can indicate the x and y coordinates of the fixation point.  
  The fixations in this dataset are then coded according to their pass status: 
  first pass and second pass.
  
  If \code{AOI} is a single value it indicates the name or the number of the 
  column with the name of the respective area of interest (AOI) that was fixated. 
  In this case, the AOI column consists of names or numbers identifying the AOI's. 
  If \code{AOI} is a vector it indicates the name or number of the AOI columns. 
  In this case the AOI columns indicate if the respective fixation was in the 
  corresponding AOI (1) or not (0).  
  NOTE: if the names of the AOI columns passed to the function are just numbers, 
  make sure to pass these as character for the function to work properly. The 
  function does not check for this case.
  
  First pass fixations are further divided into forward and rereading 
  fixations if \code{rereading} is set to \code{TRUE}. In this case the names 
  of the columns containing the x and y coordinates of the fixation point 
  should be supplied by \code{fpx} and \code{fpy} respectively. The unit of 
  these coordinates does not matter as long as it is the same for both and for the 
  value of \code{fix_size}.
  
  It is important to set the minimal distance between fixations (or the visual 
  acuity) via \code{fix_size}. This value is used to determine if two 
  fixations are on the same line and/or on the same position in the line. 
  When this value is to small it is possible that some first-pass fixations 
  are falsely categorized as rereading fixations. Specifically \code{fix_size} 
  determines what the minimal distance between fixations should be in order 
  for fixations to be considered in a different  position on the line or on 
  a different line. The default value is specified in pixels(px). The value is 
  the number of pixels equivalent to 2 visual degrees, taken a screen of 
  1020px and about 54cm in width and a viewing distance of 60cm. 
  (see \code{\link{px2deg}} for conversions). The value of 2 visual degrees 
  is the average visual angle of the fovea (Llewellyn-Thomas, 1968; Haber & 
  Hershenson, 1973). It is recommended to play around with the \code{fix_size} 
  value for every participant.
  
  By default this function considers the first three (3) fixations in any AOI 
  as first pass fixations. And it does this regardless of whether the fixations
  are consecutive or interrupted by fixations in a different AOI. The minimal 
  number of fixations considered as first pass can be changed through 
  \code{fix_min}.
}
\examples{
  data( "SimData" )
  
  ### codePasses calculates first and second  passes
  ## if a single AOI column is provided
  # by name
  codePasses( data = SimData, AOI = "AOI" )
  
  # by column number
  codePasses( data = SimData, AOI = 5 )
  
  ## and if multiple AOI columns are provided
  # by name
  resultA <- codePasses( data = SimData, 
                         AOI = c( "AOI1", "AOI2", "AOI3" ) )
  resultA
  
  # by number
  codePasses( data = SimData, AOI = 2:4 )
  
  ## \code{fix_min} influences how many fixations are needed in an AOI  
  ## independent of any fixations in between.  
  resultB <- codePasses( data = SimData, 
                         AOI = c( "AOI1", "AOI2", "AOI3" ), fix_min = 1 )
                         
  data.frame( fix_min3 = resultA, fix_min1 = resultB )
  
  rm( resultA, resultB )
  
  ### it also calculates forward and backward first passes if the x and y
  ### coordinates of the fixations are provided and \code{rereading} is \code{TRUE}
  resultA <- codePasses( data = SimData, AOI = "AOI",
                         rereading = TRUE, fpx = "xcoord", fpy = "ycoord",
                         fix_size = 20 )
  resultA
  
  # and allows for different coordinate origins
  resultB <- codePasses( data = SimData, AOI = "AOI", rereading = TRUE,
                         fpx = "xcoord", fpy = "ycoord", origin = "bottomLeft",
                         fix_size = 20 )
   data.frame( topLeft = resultA, bottomLeft = resultB )
  
  ## mind that fix_size can influence the results
  resultB <- codePasses( data = SimData, AOI = "AOI",
                         rereading = TRUE, fpx = "xcoord", fpy = "ycoord",
                         fix_size = 10 )
  
  data.frame( fix_size20 = resultA, fix_size10 = resultB )
  
}
\references{
Haber, R. N., & Hershenson, M. (1973) \emph{The psychology of visual perception.} 
  New York: Holt, Rinehart, and Winston.
    
  Llewellyn-Thomas, E. (1968) Movements of the eye. \emph{Scientific American, 219}(2), 
  88-95.  
    
  Hyönä, J., Lorch, R. F., & Rinck, M. (2003). Eye movement measures to study 
  global text processing. In J. Hyönä, R. Radach, & H. Deubel (Eds.), \emph{The mind's 
  eye: cognitive and applied aspects of eye movement research} (pp. 313-334). 
  Amsterdam: Elsevier Science.  
    
  Hyönä, J., & Lorch, R. F. (2004). Effects of topic headings on text processing: 
  evidence from adult readers’ eye fixation patterns. \emph{Learning and Instruction, 
  14}, 131-152. doi:10.1016/j.learninstruc.2004.01.001
}
