% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upper_bound.R
\name{upper_bound}
\alias{upper_bound}
\alias{upper_bound.evmm}
\title{Upper Bound}
\usage{
upper_bound(x, ...)

\method{upper_bound}{evmm}(x, cred = 0.95, ...)
}
\arguments{
\item{x}{the output of a model estimated with \code{extrememix}.}

\item{...}{additional arguments for compatibility.}

\item{cred}{amplitude of the posterior credibility interval.}
}
\value{
\code{upper_bound} returns a list with entries: \itemize{
\item \code{bound}: a sample from the posterior distribution of the upper limit of the model, taken over the posterior values of xi which are negative.
\item \code{prob}: the posterior probability that the distribution is unbounded.
\item \code{cred}: the requested amplitude of the posterior credibility intervals.
}
}
\description{
Computation of the upper bound of the distribution
}
\details{
For an extreme value mixture model with a shape parameter \eqn{xi < 0} the distribution is right-bounded with upper limit equal to \eqn{u-\sigma/\xi}.
}
\examples{
upper_bound(rainfall_ggpd)

}
\references{
Coles, Stuart, et al. An introduction to statistical modeling of extreme values. Vol. 208. London: Springer, 2001.
}
