% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_measure_sets.R
\name{guess_measure_sets}
\alias{guess_measure_sets}
\title{Guess a measure set using regexs}
\usage{
guess_measure_sets(
  data,
  measure_regexs = getOption("expstudy.default_measure_regexs"),
  measure_set_prefixes = getOption("expstudy.default_measure_set_prefixes"),
  measure_set_suffixes = getOption("expstudy.default_measure_set_suffixes")
)
}
\arguments{
\item{data}{A \code{\link{data.frame}} that houses an experience study.}

\item{measure_regexs}{A named list of patterns to use as regexs when guessing columns in the
study dataset to be used for one study measure in each measure set. There
must be one column for each measure in a measure set (actuals, expecteds,
exposures, and variances). Defaults to
\code{getOption('expstudy.default_measure_regexs')}.}

\item{measure_set_prefixes, measure_set_suffixes}{Character vectors that will be use to differentiate the same measure in
one measure set from another measure set. Using \code{NULL} indicates that
the study measures do not differ by prefix/suffix and will error if more
than one column is guessed using the measure regex for a single measure.
Defaults to measures sets not differing by prefix
(\code{measure_set_prefixes = NULL}) but do differ by count and amount
suffixes (\code{measure_set_prefixes = c('_CNT', '_AMT')}).

If the experience study has columns that follow a consistent naming
structure, this function can seamlessly provide other \code{expstudy} functions
information on the study measures to use for various calculations.}
}
\value{
A named list of measure sets that identify common variables used for
\code{expstudy} analyses.
}
\description{
Attempt to guess the names of a \strong{measure set} using regular expressions
(or regexs).
}
\examples{
guess_measure_sets(mortexp)

}
