% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_rule.R
\name{stop_rule_d1ph}
\alias{stop_rule_d1ph}
\title{Generating a stop rule function for EWOC proportional hazards model}
\usage{
stop_rule_d1ph(step)
}
\arguments{
\item{step}{an object from the class 'ewoc_d1ph'.}
}
\value{
a logical character indicating if the trial should be stopped or not.
}
\description{
Generating a stop rule function for EWOC proportional hazards model
}
\details{
The stop rule function is evaluated at each step of the trial.
It can defined based on any information contained in the object 'step' that
is the output from one of the functions 'ewoc_d1ph'.
}
\examples{
\dontshow{
time <- 9
status <- 0
dose <- 20
step_zero <- ewoc_d1ph(cbind(time, status) ~ dose, type = 'discrete',
                      theta = 0.33, alpha = 0.25, tau = 10,
                      min_dose = 20, max_dose = 100,
                      dose_set = seq(20, 100, 20),
                      rho_prior = matrix(1, ncol = 2, nrow = 1),
                      mtd_prior = matrix(1, ncol = 2, nrow = 1),
                      distribution = 'exponential',
                      rounding = 'nearest')
stop_rule_d1ph(step_zero)
response_sim <- response_d1ph(rho = 0.05, mtd = 20, theta = 0.33,
                             min_dose = 10, max_dose = 50,
                             tau = 10, distribution = "exponential")
sim <- ewoc_simulation(step_zero = step_zero,
                      n_sim = 1, sample_size = 2,
                      alpha_strategy = "conditional",
                      response_sim = response_sim,
                      stop_rule_sim = stop_rule_d1ph,
                      ncores = 1)
}

\dontrun{
time <- 9
status <- 0
dose <- 20
step_zero <- ewoc_d1ph(cbind(time, status) ~ dose, type = 'discrete',
                      theta = 0.33, alpha = 0.25, tau = 10,
                      min_dose = 20, max_dose = 100,
                      dose_set = seq(20, 100, 20),
                      rho_prior = matrix(1, ncol = 2, nrow = 1),
                      mtd_prior = matrix(1, ncol = 2, nrow = 1),
                      distribution = 'exponential',
                      rounding = 'nearest')
stop_rule_d1ph(step_zero)
response_sim <- response_d1ph(rho = 0.05, mtd = 20, theta = 0.33,
                             min_dose = 10, max_dose = 50,
                             tau = 10, distribution = "exponential")
sim <- ewoc_simulation(step_zero = step_zero,
                      n_sim = 2, sample_size = 30,
                      alpha_strategy = "conditional",
                      response_sim = response_sim,
                      stop_rule_sim = stop_rule_d1ph,
                      ncores = 1)
}
}
