% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gev_influence_rl.R
\name{gev_influence_rl}
\alias{gev_influence_rl}
\alias{plot.gev_influence_rl}
\title{GEV influence curves for return levels}
\usage{
gev_influence_rl(z, mu = 0, sigma = 1, xi = 0, m, npy = 1)

\method{plot}{gev_influence_rl}(x, xvar = c("z", "y"), vlines, ...)
}
\arguments{
\item{z}{A numeric vector. Values of normal quantiles \eqn{z} at which to
calculate the GEV influence function. See \strong{Details}.}

\item{mu, sigma, xi}{Numeric scalars supplying the values of the GEV
parameters \eqn{\mu}, \eqn{\sigma} and \eqn{\xi}.}

\item{m}{A numeric vector of length 3 containing 3 unique return periods
in years. All entries in \code{m} must be greater than 1.}

\item{npy}{A numeric scalar.  The number \eqn{n_{py}} of block maxima per
year. If the blocks are of length 1 year then \code{npy = 1}.}

\item{x}{An object inheriting from class \code{"gev_influence_rl"}, returned from
a call to \code{\link{gev_influence_rl}}.}

\item{xvar}{A logical scalar.
If \code{xvar = "z"} then the influence curves are plotted against the standard
normal quantiles in \code{x[, "z"]}.
If \code{xvar = "y"} then the influence curves are plotted against the
corresponding GEV quantiles in \code{x[, "y"]}.}

\item{vlines}{A numeric vector. If \code{vlines} is supplied then black dashed
vertical lines are added to the plot at the values in \code{vlines} on the
horizontal axis. This might be used to indicate the values of certain
observations in a dataset.}

\item{...}{For \code{plot.gev_influence_rl}: to pass graphical parameters to the
graphical functions \code{\link[graphics:plot.default]{matplot}} and
\code{\link[graphics:legend]{legend}}. The parameters \verb{col, lty} and \code{lwd} can be
used to control line colour, type and width, with the return levels in
the order that they were supplied in \code{m}.}
}
\value{
\code{gev_influence_rl}: an object with class
\code{c("gev_influence_rl", "matrix", "array")}, a \code{length(z)} by \code{5} numeric
matrix. The first two columns contain the input values in \code{z} and the
corresponding values of \code{y}. Columns 3-5 contain the values of the GEV
influence function for the return levels in \code{m} respectively at the values
of \code{z}.

\code{plot.gev_influence_rl}: a list of the graphical parameters used in producing
the plot, either the defaults or supplied via \code{...}, is returned
invisibly.
}
\description{
Calculates influence function curves for maximum likelihood estimators of
3 return levels based on Generalised Extreme Value (GEV) parameters.
}
\details{
See \code{\link{gev_influence}} for information about influence functions in
general and influence curves for the parameters of a GEV distribution in
particular. The GEV influence curves are reparameterised from
\eqn{(\mu, \sigma, \xi)} to the required return levels.
}
\examples{
# Influence curves based on the adjusted fit to the Plymouth ozone data
z <- seq(from = -3, to = 3, by = 0.01)
fit <- gev_mle(PlymouthOzoneMaxima)
pars <- coef(fit)
m <- c(25, 50, 100)
infp <- gev_influence_rl(z = z, mu = pars[1], sigma = pars[2], xi = pars[3],
                         m = m)
plot(infp)
}
\references{
Hampel, F. R., Ronchetti, E. M., Rousseeuw, P. J., and
Stahel, W. A. (2005). Robust Statistics. Wiley-Interscience, New York.
\doi{10.1002/9781118186435}

Davison, A. C. and Smith, R. L. (1990). Models for exceedances
over high thresholds. Journal of the Royal Statistical Society: Series B
(Methodological), 52(3):393–425. \doi{10.1111/j.2517-6161.1990.tb01796.x}
}
\seealso{
\code{\link{gev_influence}}, \code{\link{gev_return}}
}
