% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_overlay.R
\name{\%at\%}
\alias{\%at\%}
\title{Combine stats and site list to overlay plot}
\usage{
stat \%at\% site
}
\arguments{
\item{stat}{data.frame with stats or other variable (containing row.names and other variables)}

\item{site}{data.frame with site list (containing row.names, lat and lon)}
}
\value{
SpatVector (terra package)
}
\description{
combines the stats (from individual station evaluation) and site list in a SpatVector using row.names
}
\examples{

sites <- data.frame(lat = c(-22.72500,-23.64300,-20.34350),
                    lon = c(-47.34800,-46.49200,-40.31800),
                    row.names = c('Americana','SAndre','VVIbes'),
                    stringsAsFactors = F)
model<- readRDS(paste0(system.file("extdata",package="eva3dm"),"/model.Rds"))
obs  <- readRDS(paste0(system.file("extdata",package="eva3dm"),"/obs.Rds"))

# evaluation by station
stats <- eva(mo = model, ob = obs, site = "Americana")
stats <- eva(mo = model, ob = obs, site = "SAndre",table = stats)
stats <- eva(mo = model, ob = obs, site = "VVIbes",table = stats)
# evaluation using all stations
stats <- eva(mo = model, ob = obs, site = "ALL", table = stats)

print(stats)

geo_stats <- stats \%at\% sites

print(geo_stats)

}
