% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_eurostat_dic.R
\name{get_eurostat_dic}
\alias{get_eurostat_dic}
\title{Download Eurostat Dictionary}
\usage{
get_eurostat_dic(dictname, lang = "en")
}
\arguments{
\item{dictname}{A character, dictionary for the variable to be downloaded.}

\item{lang}{A character, language code. Options: "en" (default), "fr", "de".}
}
\value{
tibble with two columns: code names and full names.
}
\description{
Download a Eurostat dictionary.
}
\details{
For given coded variable from Eurostat
\url{https://ec.europa.eu/eurostat/}. The dictionaries link codes with
human-readable labels. To translate codes to labels, use
\code{\link[=label_eurostat]{label_eurostat()}}.
}
\examples{
\dontshow{if (check_access_to_data()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
get_eurostat_dic("crop_pro")

# Try another language
get_eurostat_dic("crop_pro", lang = "fr")
}
\dontshow{\}) # examplesIf}
}
\references{
See \code{citation("eurostat")}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# Kindly cite the eurostat R package as follows:
# 
#   Lahti L., Huovari J., Kainu M., and Biecek P. (2017). Retrieval and
#   analysis of Eurostat open data with the eurostat package. The R
#   Journal 9(1), pp. 385-392. doi: 10.32614/RJ-2017-019
# 
#   Lahti, L., Huovari J., Kainu M., Biecek P., Hernangomez D., Antal D.,
#   and Kantanen P. (2023). eurostat: Tools for Eurostat Open Data
#   [Computer software]. R package version 4.0.0.
#   https://github.com/rOpenGov/eurostat
# 
# To see these entries in BibTeX format, use 'print(<citation>,
# bibtex=TRUE)', 'toBibtex(.)', or set
# 'options(citation.bibtex.max=999)'.
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=label_eurostat]{label_eurostat()}}, \code{\link[=get_eurostat]{get_eurostat()}},
\code{\link[=search_eurostat]{search_eurostat()}}.
}
\author{
Przemyslaw Biecek and Leo Lahti \href{mailto:leo.lahti@iki.fi}{leo.lahti@iki.fi}. Thanks to
Wietse Dol for contributions. Updated by Pyry Kantanen to support XML
codelists.
}
\keyword{database}
\keyword{utilities}
