% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-game-points.R
\name{getGamePoints}
\alias{getGamePoints}
\title{Get game points}
\usage{
getGamePoints(season_code, game_code)
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{game_code}{One or more game codes as obtained from \code{\link[=getCompetitionGames]{getCompetitionGames()}}.}
}
\value{
Returns scoring information of each player for the chosen games and
seasons (subset of play-by-play data).
In particular:
\itemize{
\item \strong{NumberOfPlay}. Reference id of the action (useful for join with results
of \code{getPlayByPlay})
\item \strong{CoordX} and \strong{CoordY}. Spatial coordinates of the shot
\item \strong{Zone}. Area of the court of the shot
}

Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/game-center/2023-24/crvena-zvezda-meridianbet-belgrade-ldlc-asvel-villeurbanne/E2023/1/#play-by-play}{PlayByPlay}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{

\dontrun{

getGamePoints(season_code = c("E2023", "U2023"), game_code = 1)

}

}
