% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-history.R
\name{save-ggplot-multi-module}
\alias{save-ggplot-multi-module}
\alias{save_multi_ggplot_ui}
\alias{save_multi_ggplot_server}
\title{Save multiple \code{ggplot} module}
\usage{
save_multi_ggplot_ui(
  id,
  output_format = c("png", "pdf", "svg", "jpeg", "pptx")
)

save_multi_ggplot_server(
  id,
  plot_list_r = reactive(NULL),
  filename = "code-ggplot",
  placeholder = "No plots to display",
  code_pre = "library(ggplot2)"
)
}
\arguments{
\item{id}{Module ID.}

\item{output_format}{Output formats offered to the user.}

\item{plot_list_r}{A \code{reactive} function returning a list of plots and codes to export.
Sub list items can have following names:
\itemize{
\item \code{ggobj}: the \code{ggplot} object producing the plot
\item \code{code}: code to produce the chart (optional)
\item \code{label}: a label to identify the plot
}}

\item{filename}{Name for the file exported.}

\item{placeholder}{A placeholder message to be displayed if \code{plot_list_r} return an empty list.}

\item{code_pre}{Some code to put before plots code.}
}
\value{
No value. Use in UI & server in shiny application.
}
\description{
Save multiple \code{ggplot} objects in various format and retrieve code.
}
\examples{
library(shiny)
library(ggplot2)
library(esquisse)
library(bslib)

ui <- page_fluid(
  theme = bs_theme_esquisse(),
  save_multi_ggplot_ui("mod")
)

server <- function(...) {

  p1 <- ggplot(mtcars) + geom_point(aes(mpg, disp))
  p2 <- ggplot(mtcars) + geom_boxplot(aes(gear, disp, group = gear))
  p3 <- ggplot(mtcars) + geom_smooth(aes(disp, qsec))
  p4 <- ggplot(mtcars) + geom_bar(aes(carb))
  p5 <- ggplot(presidential) +
    geom_segment(aes(y = name, x = start, xend = end)) +
    geom_point(aes(y = name, x = start)) +
    geom_point(aes(y = name, x = end))

  save_multi_ggplot_server(
    id = "mod",
    plot_list_r = reactive(list(
      list(
        ggobj = p1,
        code = "ggplot(mtcars) + geom_point(aes(mpg, disp))",
        label = "Plot 1"
      ),
      list(
        ggobj = p2,
        code = "ggplot(mtcars) + geom_boxplot(aes(gear, disp, group = gear))",
        label = "Plot 2"
      ),
      list(
        ggobj = p3,
        code = "ggplot(mtcars) + geom_smooth(aes(disp, qsec))",
        label = "Plot 3"
      ),
      list(
        ggobj = p4,
        code = "ggplot(mtcars) + geom_bar(aes(carb))",
        label = "Plot 4"
      ),
      list(
        ggobj = p5,
        code = "ggplot(presidential) +
  geom_segment(aes(y = name, x = start, xend = end)) +
  geom_point(aes(y = name, x = start)) +
  geom_point(aes(y = name, x = end))",
        label = "Plot 5"
      )
    ))
  )
}

if (interactive())
  shinyApp(ui, server)


}
